/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import {
    type Localization,
    type ValidateFunctionInterface,
    type ValidateOptions,
    type ValidateResult,
} from '@form-validation/core';

export interface StringCaseOptions extends ValidateOptions {
    // Can be 'lower' (default) or 'upper'
    case: string;
}
export interface StringCaseLocalization extends Localization {
    stringCase: {
        default: string;
        upper: string;
    };
}

export function stringCase(): ValidateFunctionInterface<StringCaseOptions, ValidateResult>;
