<?php $__env->startSection('title', 'Student Profile'); ?>

<?php $__env->startSection('content'); ?>
    <div class="col-12 col-lg-12">
        <!-- Student Information -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-tile mb-0">Student Profile</h5>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <?php endif; ?>

            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-4">
                        <!-- Display student photo if available -->
                        <?php if($student->photo_path): ?>
                            <img src="<?php echo e(asset('storage/' . $student->photo_path)); ?>" alt="Student Photo" class="img-fluid rounded mb-3">
                        <?php else: ?>
                            <img src="<?php echo e(asset('images/default-profile.png')); ?>" alt="Default Photo" class="img-fluid rounded mb-3">
                        <?php endif; ?>
                    </div>

                    <div class="col-md-8">
                        <h4>Basic Information</h4>

                        <p><strong>Full Name:</strong> <?php echo e($student->full_name); ?></p>
                        <p><strong>Father's Name:</strong> <?php echo e($student->father_name); ?></p>
                        <p><strong>Father's Job:</strong> <?php echo e($student->father_job); ?></p>
                        <p><strong>Mother's Name:</strong> <?php echo e($student->mother_name); ?></p>
                        <p><strong>Mother's Job:</strong> <?php echo e($student->mother_job); ?></p>
                        <p><strong>Date of Birth:</strong> <?php echo e($student->date_of_birth); ?></p>
                        <p><strong>Religion:</strong> <?php echo e(ucfirst($student->religion)); ?></p>
                        <p><strong>Gender:</strong> <?php echo e(ucfirst($student->gender)); ?></p>
                        <p><strong>National ID:</strong> <?php echo e($student->national_id); ?></p>
                    </div>
                </div>

                <h4>Address Information</h4>

                <p><strong>Address:</strong> <?php echo e($student->address); ?></p>
                <p><strong>District/Area:</strong> <?php echo e($student->district); ?></p>
                <p><strong>Place of Birth:</strong> <?php echo e($student->place_of_birth); ?></p>
                <p><strong>Nationality:</strong> <?php echo e($student->nationality); ?></p>

                <h4>School Information</h4>

                <p><strong>Grade:</strong> <?php echo e($student->grade->name); ?></p>
                <p><strong>School:</strong> <?php echo e($student->school->name); ?></p>
                <p><strong>Neighborhood:</strong> <?php echo e($student->neighborhood->name); ?></p>
                <p><strong>Year of Entry:</strong> <?php echo e($student->year_of_entry); ?></p>
                <p><strong>Is Transferred:</strong> <?php echo e($student->is_transferred ? 'Yes' : 'No'); ?></p>

                <?php if($student->is_transferred): ?>
                    <p><strong>Former School Name:</strong> <?php echo e($student->former_school_name); ?></p>
                <?php endif; ?>

                <h4>Contact Information</h4>

                <?php $__empty_1 = true; $__currentLoopData = $student->contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="card mb-2">
                        <div class="card-body">
                            <p><strong>Contact Number:</strong> <?php echo e($contact->contact_number); ?></p>
                            <p><strong>Type:</strong> <?php echo e(ucfirst($contact->type)); ?></p>
                            <p><strong>Owned By:</strong> <?php echo e(ucfirst($contact->owned_by)); ?></p>
                            <p><strong>Notes:</strong> <?php echo e($contact->notes ?? 'N/A'); ?></p>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p>No contact information available.</p>
                <?php endif; ?>

                <h4>Siblings</h4>

                <?php if($student->siblings->count() > 0): ?>
                    <ul>
                        <?php $__currentLoopData = $student->siblings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sibling): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <?php echo e($sibling->full_name); ?> - Grade: <?php echo e($sibling->grade->name); ?>

                                <a href="<?php echo e(route('admin.students.show', $sibling->id)); ?>" class="btn btn-link">View Profile</a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php else: ?>
                    <p>No siblings recorded.</p>
                <?php endif; ?>

                <h4>Additional Files</h4>

                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Birth Certificate:</strong></p>
                        <?php if($student->birth_certificate_path): ?>
                            <a href="<?php echo e(asset('storage/' . $student->birth_certificate_path)); ?>" target="_blank">View Birth Certificate</a>
                        <?php else: ?>
                            <p>No birth certificate uploaded.</p>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if($student->notes->count()): ?>
                    <h4>Notes</h4>
                    <ul>
                        <?php $__currentLoopData = $student->notes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <strong><?php echo e($note->user->name); ?></strong> (<?php echo e($note->created_at->format('d M Y')); ?>):
                                <?php echo e($note->note); ?>

                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php endif; ?>

                <a href="<?php echo e(route('admin.students.edit', $student->id)); ?>" class="btn btn-warning mt-3">Edit Student</a>

                <form action="<?php echo e(route('admin.students.destroy', $student->id)); ?>" method="POST" class="d-inline-block">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger mt-3" onclick="return confirm('Are you sure you want to delete this student?')">Delete Student</button>
                </form>

                <a href="<?php echo e(route('admin.students.index')); ?>" class="btn btn-primary">Back to all students</a>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\students\show.blade.php ENDPATH**/ ?>