<?php $__env->startSection('title', 'Media Library'); ?>

<?php $__env->startSection('content'); ?>
    <h4>Media Library</h4>

    <div class="card">
        <div class="card-body">
            <div id="media-library">
                <?php if(count($mediaItems) > 0): ?>
                    <?php $__currentLoopData = $mediaItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="media-item" data-id="<?php echo e($media->id); ?>">
                            <img src="<?php echo e(asset('storage/' . $media->file_path)); ?>" alt="<?php echo e($media->file_name); ?>" style="max-width: 100px;">

                            <p><?php echo e($media->file_name); ?></p>

                            <button class="btn btn-primary edit-media-btn" data-id="<?php echo e($media->id); ?>">Edit</button>

                            <form action="<?php echo e(route('admin.media.delete', $media)); ?>" method="POST" style="display:inline;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-danger">Delete</button>
                            </form>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="alert alert-info d-flex align-items-center" role="alert">
                        <span class="alert-icon rounded">
                            <i class="ti ti-info-circle"></i>
                        </span>

                        Media library is empty
                    </div>
                <?php endif; ?>
            </div>

            <?php echo e($mediaItems->links()); ?>


            <!-- Modal for editing media -->
            <div id="edit-media-modal" style="display:none;">
                <form id="edit-media-form">
                    <input type="hidden" name="media_id" id="media_id">

                    <input type="text" name="file_name" id="file_name">

                    <button type="submit">Save</button>
                </form>

                <button id="close-edit-media">Close</button>
            </div>

            <!-- jQuery for media library actions -->
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
            <script>
                $(document).ready(function() {
                    // Open edit modal
                    $('.edit-media-btn').on('click', function() {
                        let mediaId = $(this).data('id');
                        let fileName = $(this).siblings('p').text();
                        $('#media_id').val(mediaId);
                        $('#file_name').val(fileName);
                        $('#edit-media-modal').show();
                    });

                    // Close edit modal
                    $('#close-edit-media').on('click', function() {
                        $('#edit-media-modal').hide();
                    });

                    // Save edited media
                    $('#edit-media-form').on('submit', function(event) {
                        event.preventDefault();
                        let mediaId = $('#media_id').val();
                        let fileName = $('#file_name').val();

                        $.ajax({
                            url: `/admin/media/edit/${mediaId}`,
                            type: 'POST',
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>',
                                file_name: fileName
                            },
                            success: function() {
                                location.reload();  // Reload the page on success
                            }
                        });
                    });
                });
            </script>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\media\library.blade.php ENDPATH**/ ?>