<?php
    $customizerHidden = 'customizer-hide';
?>



<?php $__env->startSection('title', 'Login Basic - Pages'); ?>

<?php $__env->startSection('vendor-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/@form-validation/form-validation.scss']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/scss/pages/page-auth.scss']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/pages-auth.js']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-xxl">
        <div class="authentication-wrapper authentication-basic container-p-y">
            <div class="authentication-inner py-4">
                <!-- Login -->
                <div class="card">
                    <div class="card-body">
                        <!-- Logo -->
                        <div class="app-brand justify-content-center mb-4 mt-2">
                            <a href="<?php echo e(url('/')); ?>" class="app-brand-link gap-2">
                                <span class="app-brand-logo demo"><?php echo $__env->make('_partials.macros', ['height' => 20, 'withbg' => 'fill: #fff;'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                                
                                <span class="app-brand-text demo text-body fw-bold ms-1"><?php echo e(config('variables.templateName')); ?></span>
                            </a>
                        </div>
                        <!-- /Logo -->

                        <h4 class="mb-1 pt-2">Welcome to <?php echo e(config('variables.templateName')); ?>! 👋</h4>

                        <p class="mb-4">Please sign-in to your account and start the adventure</p>

                        <!--begin::Form-->
                        <form method="POST" class="form w-100" novalidate="novalidate" action="<?php echo e(route('storeInvitation')); ?>">
                            <?php echo csrf_field(); ?> 

                            <?php if(session('error')): ?>
                                <div class="alert alert-danger">
                                    <p><?php echo e(session('error')); ?></p>
                                </div>
                            <?php endif; ?>

                            <?php if(session('success')): ?>
                                <div class="alert alert-success">
                                    <p><?php echo e(session('success')); ?></p>
                                </div>
                            <?php endif; ?>
                            
                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger">
                                    <?php echo e($errors->first()); ?>

                                </div>
                            <?php endif; ?>

                            <!--begin::Heading-->
                            <div class="text-center mb-11">
                                <!--begin::Title-->
                                <h1 class="text-dark fw-bolder mb-3">
                                <?php echo e(__('Request Invitation')); ?>

                                </h1>
                                <!--end::Title-->
                            </div>
                            <!--begin::Heading-->

                            <!--begin::Input group--->
                            <div class="fv-row mb-8">
                                <!--begin::Email-->
                                <input type="text" placeholder="Email" name="email" value="<?php echo e(old('email')); ?>" autocomplete="off" class="form-control bg-transparent"/>
                                <!--end::Email-->
                            </div>

                            <div class="col-xs-12 col-sm-12 col-md-12">
                                <div class="form-group">
                                    <strong>Permissions:</strong><br>
                                    
                                    <?php $__currentLoopData = $permission; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <label>
                                            <input type="checkbox" name="permissions[]" value="<?php echo e($value->id); ?>" class="name" /> <?php echo e($value->name); ?>

                                            
                                            
                                        </label>
                                        <br/>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <br>
                                </div>
                            </div>

                            <!--begin::Submit button-->
                            <div class="d-grid mb-10">
                                <button type="submit" id="kt_sign_up_submit" class="btn btn-primary">
                                    <?php echo $__env->make('partials/general/_button-indicator', ['label' => 'Request An Invitation'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </button>
                            </div>
                            <!--end::Submit button-->
                        </form>
                        <!--end::Form-->
                    </div>
                </div>
                <!-- /Login -->
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\auth\request.blade.php ENDPATH**/ ?>