<?php $__env->startSection('title', 'District: '. $district->name); ?>

<?php $__env->startSection('content'); ?>
    <div class="col-12 col-lg-12">
        <!-- District Information -->

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-tile mb-0">District: <?php echo e($district->name); ?></h5>
            </div>

            <div class="card-body">
                <div class="mb-3">
                    <p>Total Students: 
                        <?php echo e($district->neighborhoods->sum(function ($neighborhood) {
                            return $neighborhood->students->count();
                        })); ?>

                    </p>
                    
                    <!-- Check if there are neighborhoods -->
                    <?php if($district->neighborhoods->count() > 0): ?>
                        <!-- You can also list neighborhoods and their student counts if needed -->
                        <ul>
                            <?php $__currentLoopData = $district->neighborhoods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $neighborhood): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <?php echo e($neighborhood->name); ?> - Students: <?php echo e($neighborhood->students->count()); ?>

                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php else: ?>
                        <p>No neighborhoods assigned to this district yet.</p>
                    <?php endif; ?>

                    <a href="<?php echo e(route('districts.index')); ?>" class="btn btn-primary">Back to districts</a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\districts\show.blade.php ENDPATH**/ ?>