<?php $__env->startSection('title', 'School: '. $school->name); ?>

<?php $__env->startSection('content'); ?>
    <div class="container mt-4">
        <div class="card">
            <div class="card-header">
                <h4>School: <?php echo e($school->name); ?></h4>
            </div>
            <div class="card-body">
                <h5>School Information</h5>
                <p><strong>Name:</strong> <?php echo e($school->name); ?></p>
                <p><strong>Address:</strong> <?php echo e($school->address); ?></p>
                <p><strong>Phone:</strong> <?php echo e($school->phone); ?></p>
                <p><strong>Principal:</strong> <?php echo e($school->principal); ?></p>

                <!-- Related Students -->
                <h5>Students</h5>
                <?php if($school->students->count() > 0): ?>
                    <ul>
                        <?php $__currentLoopData = $school->students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($student->name); ?> - <?php echo e($student->class); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php else: ?>
                    <p>No students found for this school.</p>
                <?php endif; ?>

                <!-- Related Employees -->
                <h5>Employees</h5>
                <?php if($school->users->count() > 0): ?>
                    <ul>
                        <?php $__currentLoopData = $school->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($employee->name); ?> - <?php echo e($employee->position); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php else: ?>
                    <p>No employees found for this school.</p>
                <?php endif; ?>

                <a href="<?php echo e(route('admin.schools.index')); ?>" class="btn btn-primary">Back to Schools</a>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\schools\show.blade.php ENDPATH**/ ?>