<?php $__env->startSection('title', 'Settings'); ?>

<?php $__env->startSection('content'); ?>
    <h4>Settings</h4>

    <div class="card">
        <h5 class="card-header">Settings</h5>

        <div class="card-body">
            <!-- Display success or error messages -->
            <?php if(session('success')): ?>
                <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <?php endif; ?>

            <!-- Wrap all settings in a single form -->
            <form action="<?php echo e(route('admin.settings.update')); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="<?php echo e(($setting->type == 'checkbox' || $setting->type == 'boolean') ? 'form-check mt-3' : 'mb-3'); ?>">
                        <!-- Format setting name for label -->
                        <?php
                        $label = ucwords(str_replace('_', ' ', $setting->key));
                        ?>

                        <?php if($setting->type == 'checkbox' || $setting->type == 'boolean'): ?>
                        <label for="<?php echo e($setting->key); ?>" class="form-check-label"><?php echo e($label); ?></label>
                        <?php else: ?>
                        <label for="<?php echo e($setting->key); ?>" class="form-label"><?php echo e($label); ?></label>
                        <?php endif; ?>

                        
                        <?php if($setting->type == 'text'): ?>
                            <input type="text" name="<?php echo e($setting->key); ?>" id="<?php echo e($setting->key); ?>" class="form-control" value="<?php echo e($setting->value); ?>">

                        
                        <?php elseif($setting->type == 'textarea'): ?>
                            <textarea name="<?php echo e($setting->key); ?>" id="<?php echo e($setting->key); ?>" class="form-control" rows="4"><?php echo e($setting->value); ?></textarea>

                        
                        <?php elseif($setting->type == 'file'): ?>
                            <input type="file" name="<?php echo e($setting->key); ?>" id="<?php echo e($setting->key); ?>" class="form-control-file">
                            
                            <?php if($setting->value !== null): ?>
                                <p>Current File: <a href="<?php echo e(asset($setting->value)); ?>" target="_blank">View</a></p>
                            <?php endif; ?>

                        
                        <?php elseif($setting->type == 'file_multiple'): ?>
                            <input type="file" name="<?php echo e($setting->key); ?>[]" id="<?php echo e($setting->key); ?>" class="form-control-file" multiple>

                            <?php if($setting->value !== null): ?>
                                <p>Current Files:
                                    <?php $files = json_decode($setting->value, true) ?>

                                    <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e(asset($file)); ?>" target="_blank"><?php echo e($file); ?></a><br>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </p>
                            <?php endif; ?>

                        
                        <?php elseif($setting->type == 'color'): ?>
                            <input type="color" name="<?php echo e($setting->key); ?>" id="<?php echo e($setting->key); ?>" class="form-control" value="<?php echo e($setting->value); ?>">

                        
                        <?php elseif($setting->type == 'date'): ?>
                            <input type="date" name="<?php echo e($setting->key); ?>" id="<?php echo e($setting->key); ?>" class="form-control" value="<?php echo e($setting->value); ?>">

                        
                        <?php elseif($setting->type == 'checkbox' || $setting->type == 'boolean'): ?>
                            <input type="checkbox" class="form-check-input" name="<?php echo e($setting->key); ?>" id="<?php echo e($setting->key); ?>" value="1" <?php echo e($setting->value ? 'checked' : ''); ?>>

                        
                        <?php elseif($setting->type == 'radio'): ?>
                            <?php $__currentLoopData = $setting->value; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check">
                                    <input type="radio" name="<?php echo e($setting->key); ?>" value="<?php echo e($option); ?>" id="<?php echo e($setting->key); ?>_<?php echo e($loop->index); ?>" class="form-check-input" <?php echo e($setting->value == $option ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="<?php echo e($setting->key); ?>_<?php echo e($loop->index); ?>"><?php echo e($option); ?></label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        
                        <?php elseif(is_array($setting->options) || is_object($setting->options)): ?>
                                <?php $__currentLoopData = $setting->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check">
                                        <input type="radio" name="<?php echo e($setting->key); ?>" value="<?php echo e($option); ?>" class="form-check-input">
                                        <label class="form-check-label" for="<?php echo e($setting->key); ?>"><?php echo e($option); ?></label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                        
                        <?php elseif($setting->type == 'json'): ?>
                            <div id="<?php echo e($setting->key); ?>-container">
                                <?php $values = json_decode($setting->value, true) ?: []; ?>
                                
                                <?php $__currentLoopData = $values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="text" name="<?php echo e($setting->key); ?>[]" value="<?php echo e($val); ?>" class="form-control mb-2">
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <button type="button" class="btn btn-secondary mt-2" onclick="addNewField('<?php echo e($setting->name); ?>')">Add Field</button>
                        <?php endif; ?>
                        
                        
                        <?php if($setting->description): ?>
                            <small class="form-text text-muted"><?php echo e($setting->description); ?></small>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                <!-- Single Submit button for all settings -->
                <button type="submit" class="btn btn-primary">Save All Settings</button>
            </form>
        </div>
    </div>

    
    <script>
        function addNewField(settingName) {
            // Find the container where the new fields should be added
            let container = document.querySelector(`#${settingName}-container`);

            // Create a new input element
            let newInput = document.createElement('input');
            newInput.setAttribute('type', 'text');
            newInput.setAttribute('name', `${settingName}[]`);
            newInput.setAttribute('class', 'form-control mb-2'); // Add classes to style it like others

            // Append the new input to the container
            container.appendChild(newInput);
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\settings\index.blade.php ENDPATH**/ ?>