<?php $__env->startSection('title', 'Students List'); ?>

<?php $__env->startSection('content'); ?>
    <h4>Students List</h4>

    <div class="card">
        <h5 class="card-header">Students List</h5>

        <div class="card-body">
            <!-- Display success or error messages -->
            <?php if(session('success')): ?>
                <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <?php endif; ?>

            <a href="<?php echo e(route('admin.students.create')); ?>" class="btn btn-primary">Add New Student</a>
            <a href="<?php echo e(route('admin.students.trashed')); ?>" class="btn btn-secondary">View Trashed Students</a>

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>Full Name</th>
                            <th>Grade</th>
                            <th>School</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="<?php echo e($student->trashed() ? 'table-danger' : ''); ?>">
                                <td><?php echo e($student->id); ?></td>
                                <td><?php echo e($student->full_name); ?></td>
                                <td><?php echo e($student->grade->name); ?></td>
                                <td><?php echo e($student->school->name); ?></td>
                                <td>
                                    <?php echo e($student->trashed() ? 'Deleted' : 'Active'); ?>

                                </td>
                                <td>
                                <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <a class="dropdown-item" href="<?php echo e(route('admin.students.show', $student->id)); ?>">
                                            <i class="ti ti-eye me-1"></i>
                                            Student Details
                                        </a>

                                        <?php if(!$student->trashed()): ?>
                                            <a class="dropdown-item" href="<?php echo e(route('admin.students.edit', $student->id)); ?>">
                                                <i class="ti ti-pencil me-1"></i>
                                                Edit
                                            </a>
                                        
                                            <form action="<?php echo e(route('admin.students.destroy', $student->id)); ?>" method="POST" id="deleteForm<?php echo e($student->id); ?>" style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-danger btn-sm" onclick="confirmDelete('<?php echo e($student->id); ?>', 'trash')" onclick="return confirm('Are you sure?')">Delete</button>
                                            </form>
                                        <?php else: ?>
                                            <form action="<?php echo e(route('admin.students.restore', $student->id)); ?>" method="POST" style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-success btn-sm">Restore</button>
                                            </form>

                                            <form action="<?php echo e(route('admin.students.forceDelete', $student->id)); ?>" method="POST" id="deleteForm<?php echo e($student->id); ?>" style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="confirmDelete('<?php echo e($student->id); ?>', 'force')" onclick="return confirm('Permanently delete this student?')">Force Delete</button>
                                            </form>
                                        <?php endif; ?>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(studentId, type) {
                                            var messge;

                                            if(type == 'trash') {
                                                message = '';
                                            }
                                            else if(type == 'force') {
                                                message = 'You want to delete this student there might be related information to this student';
                                            }
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this student there might be related information to this student',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete this student!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + studentId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6">No students found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>

                <?php echo e($students->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\students\index.blade.php ENDPATH**/ ?>