<?php $__env->startSection('title', 'Districts'); ?>

<?php $__env->startSection('content'); ?>
    <h4>All Districts</h4>

    <div class="card">
        <h5 class="card-header">Districts Table</h5>

        <a href="<?php echo e(route('districts.create')); ?>">Add District</a>
        
        <div class="card-body">
            <!-- Display success or error messages -->
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Name</th>
                            <th>Total Students</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php echo e($district->name); ?> (Neighborhoods: <?php echo e($district->neighborhoods->count()); ?>)
                                </td>
                                <td>
                                    <?php echo e($district->neighborhoods->sum(function ($neighborhood) {
                                            return $neighborhood->students->count();
                                        })); ?> Students
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <a class="dropdown-item" href="<?php echo e(route('districts.edit', $district->id)); ?>">
                                            <i class="ti ti-pencil me-1"></i>
                                            Edit
                                        </a>

                                        <a class="dropdown-item" href="<?php echo e(route('districts.show', $district->id)); ?>">
                                            <i class="ti ti-eye me-1"></i>
                                            Show District
                                        </a>

                                        <form action="<?php echo e(route('districts.destroy', $district->id)); ?>" method="POST" id="deleteForm<?php echo e($district->id); ?>" style="display:inline;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>

                                            <button type="submit" class="dropdown-item btn btn-danger" onclick="confirmDelete('<?php echo e($district->id); ?>')">
                                                <i class="ti ti-trash me-1"></i>
                                                Delete
                                            </button>
                                        </form>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(districtId) {
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this district there might be related neighborhoods to this district',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + districtId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\districts\index.blade.php ENDPATH**/ ?>