<?php $__env->startSection('title', 'Schools'); ?>

<?php $__env->startSection('content'); ?>
    <h4>All Schools</h4>

    <div class="card">
        <h5 class="card-header">Schools Table</h5>

        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <?php endif; ?>

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Logo</th>
                            <th>Name</th>
                            <th>City</th>
                            <th>State</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr <?php if($school->trashed()): ?> class="table-warning" <?php endif; ?>>
                                <td>
                                    <?php if($school->logo): ?>
                                        <img src="<?php echo e(asset('storage/' . $school->logo)); ?>" alt="<?php echo e($school->name); ?>" style="max-width: 100px;">
                                    <?php else: ?>
                                        No Logo
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($school->name); ?></td>
                                <td><?php echo e($school->city); ?></td>
                                <td><?php echo e($school->state); ?></td>
                                <td><?php echo e($school->status); ?></td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <?php if(!$school->trashed()): ?>
                                            <a class="dropdown-item" href="<?php echo e(route('admin.schools.edit', $school->id)); ?>">
                                                <i class="ti ti-pencil me-1"></i>
                                                Edit
                                            </a>

                                            <a class="dropdown-item" href="<?php echo e(route('admin.schools.show', $school->id)); ?>">
                                                <i class="ti ti-eye me-1"></i>
                                                Show
                                            </a>

                                            <form action="<?php echo e(route('admin.schools.destroy', $school->id)); ?>" method="POST"  id="deleteForm<?php echo e($school->id); ?>" style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>

                                                <button type="submit" class="dropdown-item btn btn-danger">
                                                    <i class="ti ti-trash me-1"></i>
                                                    Delete
                                                </button>
                                            </form>
                                        <?php else: ?>
                                            <div class="dropdown-menu">
                                                <form action="<?php echo e(route('admin.schools.restore', $school->id)); ?>" method="POST" style="display:inline;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PATCH'); ?>

                                                    <button type="submit" class="dropdown-item btn btn-success">
                                                        <i class="ti ti-restore me-1"></i>
                                                        Restore
                                                    </button>
                                                </form>

                                                <form action="<?php echo e(route('admin.schools.forceDelete', $school->id)); ?>" method="POST" style="display:inline;" id="deleteForm<?php echo e($school->id); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>

                                                    <button type="submit" class="dropdown-item btn btn-danger" onclick="confirmDelete('<?php echo e($school->id); ?>')">
                                                        <i class="ti ti-trash me-1"></i>
                                                        Force Delete
                                                    </button>
                                                </form>
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(schoolId) {
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this school! There might be related employees or students to this school',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + schoolId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                    
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <?php echo e($schools->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\schools\index.blade.php ENDPATH**/ ?>