<?php $__env->startSection('title', 'Roles'); ?>

<?php $__env->startSection('content'); ?>
    <h4>All Roles</h4>

    <div class="card">
        <h5 class="card-header">Roles Table</h5>

        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Name</th>
                            <th>Permissions Count</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($role->name); ?></td>
                                <td><?php echo e($role->permissions_count); ?></td> <!-- Display permissions count -->
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="<?php echo e(route('admin.roles.edit', $role->id)); ?>">
                                                <i class="ti ti-pencil me-1"></i>
                                                Edit
                                            </a>

                                            <a class="dropdown-item" href="<?php echo e(route('admin.roles.show', $role->id)); ?>">
                                                <i class="ti ti-eye me-1"></i>
                                                Show
                                            </a>
                                            
                                            <?php if($role->id != 1): ?> <!-- Assuming Super Admin has ID 1 -->
                                                <form action="<?php echo e(route('admin.roles.destroy', $role->id)); ?>" method="POST" class="d-inline" id="deleteForm<?php echo e($role->id); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button" class="dropdown-item delete-role-btn" data-role-id="<?php echo e($role->id); ?>" onclick="confirmDelete('<?php echo e($role->id); ?>')">
                                                        <i class="ti ti-trash me-1"></i>
                                                        Delete
                                                    </button>
                                                </form>
                                            <?php else: ?>
                                                <button type="button" class="dropdown-item" disabled><i class="ti ti-trash me-1"></i> Delete Disabled</button>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(authorId) {
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this role! There might be permissions related to this role and this role might be assigned to one of the employees',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + authorId).submit();
                                                }
                                            });
                                        }

                                        document.addEventListener('DOMContentLoaded', function () {
                                            document.querySelectorAll('.delete-role-btn').forEach(function (button) {
                                                button.addEventListener('click', function (e) {
                                                    const roleId = button.getAttribute('data-role-id');

                                                    // Assuming '1' is the ID for Super Admin role
                                                    if (roleId == 1) {
                                                        e.preventDefault();
                                                        alert('You cannot delete the Super Admin role.');
                                                    }
                                                });
                                            });
                                        });
                                    </script>
                                    
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views/dashboard/roles/index.blade.php ENDPATH**/ ?>