<?php $__env->startSection('title', 'Users'); ?>

<?php $__env->startSection('content'); ?>
    <h4>All Users</h4>

    <div class="card">
        <h5 class="card-header">Users Table</h5>

        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Name</th>
                            <th style="width:100px">Status</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Photo</th>
                            <th>Roles</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if($user->isSuperAdmin()): ?>
                                    <i class="tf-icons ti ti-crown" id="crown"></i>
                                    <?php endif; ?>
                                    
                                    <?php echo e($user->name); ?>

                                </td>
                                <td>
                                    <span id="user-<?php echo e($user->id); ?>">
                                        <?php if($user->online == 1): ?>
                                            <div class="online-indicator"><span class="blink"></span></div> Online
                                        <?php else: ?>
                                            <div class="offline-indicator"></div> Offline
                                        <?php endif; ?>
                                    </span>
                                </td>
                                <td><?php echo e($user->email); ?></td>
                                <td><?php echo e($user->phone); ?></td>
                                <td>
                                    <?php if($user->photo): ?>
                                        <img src="<?php echo e(asset('images/' . $user->photo)); ?>" width="50" alt="User Photo">
                                    <?php else: ?>
                                        N/A
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(implode(', ', $user->roles->pluck('name')->toArray())); ?></td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="<?php echo e(route('admin.users.edit', $user->id)); ?>">
                                                <i class="ti ti-pencil me-1"></i>
                                                Edit
                                            </a>

                                            <a class="dropdown-item" href="<?php echo e(route('admin.users.show', $user->id)); ?>">
                                                <i class="ti ti-eye me-1"></i>
                                                Show
                                            </a>

                                            <!-- Check if the user is not Super Admin before showing delete button -->
                                            <?php if(!$user->hasRole('Super Admin')): ?>
                                                <?php if($user->active): ?>
                                                    <form method="POST" action="<?php echo e(route('admin.users.deactivate', $user)); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PATCH'); ?>
                                                        <button type="submit" class="dropdown-item btn btn-danger">
                                                            <i class="ti ti-cog me-1"></i>
                                                            
                                                            Deactivate
                                                        </button>
                                                    </form>
                                                <?php else: ?>
                                                    <form method="POST" action="<?php echo e(route('admin.users.activate', $user)); ?>">
                                                        <?php echo csrf_field(); ?>

                                                        <?php echo method_field('PATCH'); ?>

                                                        <button type="submit" class="dropdown-item btn btn-success">
                                                            <i class="ti ti-cog me-1"></i>
                                                            Activate
                                                        </button>
                                                    </form>
                                                <?php endif; ?>

                                                <form action="<?php echo e(route('admin.users.destroy', $user->id)); ?>" method="POST" class="d-inline" id="deleteForm<?php echo e($user->id); ?>">
                                                    <?php echo csrf_field(); ?>

                                                    <?php echo method_field('DELETE'); ?>

                                                    <button type="button" class="dropdown-item" onclick="confirmDelete('<?php echo e($user->id); ?>')">
                                                        <i class="ti ti-trash me-1"></i>
                                                        Delete
                                                    </button>
                                                </form>
                                            <?php else: ?>
                                                <button type="button" class="dropdown-item" disabled><i class="ti ti-trash me-1"></i> Delete Disabled</button>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(authorId) {
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this user',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete this user!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + authorId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                    
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views/dashboard/users/index.blade.php ENDPATH**/ ?>