<?php $__env->startSection('title', 'Grade: '. $grade->name); ?>

<?php $__env->startSection('content'); ?>
    <div class="col-12 col-lg-12">
        <!-- Role Information -->

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-tile mb-0">Grade: <?php echo e($grade->name); ?></h5>
            </div>

            <div class="card-body">
                <div class="mb-3">
                    <label>Assigned Students:</label>

                    <!-- Check if there are students -->
                    <?php if($students->count() > 0): ?>
                        <ul>
                            <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($student->name); ?> (School: <?php echo e($student->school->name); ?>)</li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>

                        <!-- Display pagination controls -->
                        <div>
                            <?php echo e($students->links()); ?>

                        </div>
                    <?php else: ?>
                        <p>No students assigned to this grade yet.</p>
                    <?php endif; ?>

                    <a href="<?php echo e(route('grades.index')); ?>" class="btn btn-primary">Back to Grades</a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\grades\show.blade.php ENDPATH**/ ?>