<?php $__env->startSection('title', 'Grades'); ?>

<?php $__env->startSection('content'); ?>
    <h4>All Grades</h4>

    <div class="card">
        <h5 class="card-header">Grades Table</h5>

        <a href="<?php echo e(route('grades.create')); ?>">Add Grade</a>
        
        <div class="card-body">
            <!-- Display success or error messages -->
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Name</th>
                            <th>Number of students</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $grades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php echo e($grade->name); ?>

                                </td>
                                <td>
                                    <?php echo e($grade->students_count); ?> students
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <a class="dropdown-item" href="<?php echo e(route('grades.edit', $grade->id)); ?>">
                                            <i class="ti ti-pencil me-1"></i>
                                            Edit
                                        </a>

                                        <a class="dropdown-item" href="<?php echo e(route('grades.show', $grade->id)); ?>">
                                            <i class="ti ti-eye me-1"></i>
                                            Show Students
                                        </a>

                                        <form action="<?php echo e(route('grades.destroy', $grade->id)); ?>" method="POST" id="deleteForm<?php echo e($grade->id); ?>" style="display:inline;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>

                                            <button type="button" class="dropdown-item btn btn-danger" onclick="confirmDelete(event, '<?php echo e($grade->id); ?>')">
                                                <i class="ti ti-trash me-1"></i>
                                                Delete
                                            </button>
                                        </form>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(event, gradeId) {
                                            // Prevent the default form submission
                                            event.preventDefault();

                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this grade there might be related students to this grade',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + gradeId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\grades\index.blade.php ENDPATH**/ ?>