<?php $__env->startSection('title', 'Trashed Students'); ?>

<?php $__env->startSection('content'); ?>
    <h4>Trashed Students</h4>

    <div class="card">
        <h5 class="card-header">Schools Table</h5>

        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <?php endif; ?>

            <div class="table-responsive text-nowrap">
            <?php if(!$students->isEmpty()): ?>
                    <table class="table table-bordered table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Actions</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($student->id); ?></td>
                                    <td><?php echo e($student->name); ?></td>
                                    <td><?php echo e($student->email); ?></td>
                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </button>

                                            <a class="dropdown-item" href="<?php echo e(route('students.restore', $student->id)); ?>">
                                                <i class="ti ti-pencil me-1"></i>
                                                Restore
                                            </a>

                                            <form action="<?php echo e(route('students.forceDelete', $student->id)); ?>" method="POST"  id="deleteForm<?php echo e($student->id); ?>" style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>

                                                <button type="submit" class="dropdown-item btn btn-danger" onclick="confirmDelete('<?php echo e($student->id); ?>')">
                                                    <i class="ti ti-trash me-1"></i>
                                                    Delete Permanently
                                                </button>
                                            </form>
                                        </div>

                                        <!-- SweetAlert script -->
                                        <script>
                                            function confirmDelete(studentId) {
                                                Swal.fire({
                                                    title: 'Are you sure?',
                                                    text: 'You want to delete this student! There might be related information for this student',
                                                    icon: 'warning',
                                                    showCancelButton: true,
                                                    confirmButtonColor: '#d33',
                                                    cancelButtonColor: '#3085d6',
                                                    confirmButtonText: 'Yes, delete student!'
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        document.getElementById('deleteForm' + studentId).submit();
                                                    }
                                                });
                                            }
                                        </script>
                                        
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    
                    { $students->links() }}
                <?php else: ?>
                    <p>No trashed students found.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\students\trashed.blade.php ENDPATH**/ ?>