

<?php $__env->startSection('title', 'User Activity Logs'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <h5 class="card-header">User Activity Logs</h5>

        <div class="card-body">
            <div class="table-responsive text-nowrap">
                <!-- Search Form -->
                <form action="<?php echo e(route('admin.logs.index')); ?>" method="GET" class="mb-3">
                    <div class="form-group row">
                        <label for="search" class="col-sm-1 col-form-label">Search:</label>
                        <div class="col-sm-4">
                            <input type="text" name="search" id="search" class="form-control" value="<?php echo e(request('search')); ?>">
                        </div>
                        <div class="col-sm-1">
                            <button type="submit" class="btn btn-primary">Search</button>
                        </div>
                    </div>
                </form>

                <a href="<?php echo e(route('admin.logs.export')); ?>" class="btn btn-success mb-3">Export Logs</a>
                
                <form action="<?php echo e(route('admin.logs.clear')); ?>" method="POST" onsubmit="return confirm('Are you sure you want to clear all logs?')">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-danger">Empty Logs</button>
                </form>

                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>User</th>
                            <th>Action</th>
                            <th>Details</th>
                            <th>IP Address</th>
                            <th>User Agent</th>
                            <th>Date</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                                <td><?php echo e($log->user ? $log->user->name : 'Guest'); ?></td>
                                <td><?php echo e($log->action); ?></td>
                                <td><?php echo e($log->details); ?></td>
                                <td><?php echo e($log->ip_address); ?></td>
                                <td><?php echo e($log->user_agent); ?></td>
                                <td><?php echo e($log->created_at->format('Y-m-d H:i:s')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <?php echo e($logs->links()); ?> <!-- Pagination Links -->
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views/dashboard/logs/index.blade.php ENDPATH**/ ?>