<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>System Installation</title>
        <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    </head>

    <body>
        <div class="container">
            <h2>System Installation</h2>

            <?php if(session('status')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('status')); ?>

                </div>
            <?php endif; ?>
            
            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <?php if($tablesExist && !$settingsComplete): ?>
                <!-- Step 2: Initial Settings Form -->
                <h3>Initial Settings</h3>

                <form id="settings-form" method="POST" action="<?php echo e(route('install.setupSettings')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <div class="form-group">
                        <label for="site_name">Site Name:</label>
                        <input type="text" name="site_name" required>
                    </div>

                    <div class="form-group">
                        <label for="primary_color">Primary Color:</label>
                        <input type="text" name="primary_color" required>
                    </div>

                    <div class="form-group">
                        <label for="site_theme">Site Theme:</label>
                        <select name="site_theme" required>
                            <option value="light">Light</option>
                            <option value="dark">Dark</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="users_registration">Allow User Registration:</label>
                        <select name="users_registration" required>
                            <option value="1">Yes</option>
                            <option value="0">No</option>
                        </select>
                    </div>

                    <!-- New Fields for Logo and Favicon -->
                    <div class="form-group">
                        <label for="site_logo">Site Logo:</label>
                        <input type="file" name="site_logo" accept="image/*">
                    </div>

                    <div class="form-group">
                        <label for="site_favicon">Site Favicon:</label>
                        <input type="file" name="site_favicon" accept="image/*">
                    </div>

                    <button type="submit" class="btn btn-primary">Save Settings</button>
                </form>
            <?php elseif(!$tablesExist): ?>
                <!-- Step 1: Database Setup Form -->
                <form id="install-form" method="POST" action="<?php echo e(route('install.setup')); ?>">
                    <?php echo csrf_field(); ?>

                    <div class="form-group">
                        <label for="DB_HOST">Database Host:</label>
                        <input type="text" name="DB_HOST" required>
                    </div>

                    <div class="form-group">
                        <label for="DB_PORT">Database Port:</label>
                        <input type="text" name="DB_PORT" value="3306" required>
                    </div>

                    <div class="form-group">
                        <label for="DB_DATABASE">Database Name:</label>
                        <input type="text" name="DB_DATABASE" required>
                    </div>

                    <div class="form-group">
                        <label for="DB_USERNAME">Database Username:</label>
                        <input type="text" name="DB_USERNAME" required>
                    </div>

                    <div class="form-group">
                        <label for="DB_PASSWORD">Database Password:</label>
                        <input type="password" name="DB_PASSWORD">
                    </div>

                    <button type="submit" class="btn btn-success" id="install-button">Install</button>
                </form>
            <?php else: ?>
                <!-- System Ready Message -->
                <h2>System Ready</h2>

                <p>The database and initial settings are complete! Your system is ready to go!</p>

                <a href="<?php echo e(url('/')); ?>" class="btn btn-primary">Go to Homepage</a>
            <?php endif; ?>
        </div>

        <script>
            $(document).ready(function() {
                // Fade in the form based on whether tables exist or not
                if (!<?php echo e(json_encode($tablesExist)); ?>) {
                    $('#install-form').fadeIn();
                } 
                else if (!<?php echo e(json_encode($settingsComplete)); ?>) {
                    $('#settings-form').fadeIn();
                }

                // No longer need to test database connection with AJAX
                // The form will directly submit to the setup route
            });
        </script>
    </body>
</html>
<?php /**PATH C:\laragon\www\kholoudlab\resources\views\install\index.blade.php ENDPATH**/ ?>