<?php $__env->startSection('title', 'Edit Student'); ?>

<?php $__env->startSection('content'); ?>
<form action="<?php echo e(route('admin.students.update', $student->id)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <?php echo method_field('PUT'); ?>

        <h4>Edit Student</h4>

        <div class="col-12 col-lg-8">
            <!-- Grade Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">Student Information</h5>
                </div>

                <div class="card-body">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <!-- Basic Information -->
                    <div class="mb-3">
                        <label for="full_name">Full Name</label>
                        <input type="text" name="full_name" id="full_name" class="form-control" value="<?php echo e(old('full_name', $student->full_name)); ?>" required>
                    
                        <?php $__errorArgs = ['full_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="father_name">Father's Name</label>
                        <input type="text" name="father_name" id="father_name" class="form-control" value="<?php echo e(old('father_name', $student->father_name)); ?>" required>
                    
                        <?php $__errorArgs = ['father_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="father_job">Father's Job</label>
                        <input type="text" name="father_job" id="father_job" class="form-control" value="<?php echo e(old('father_job', $student->father_job)); ?>" required>
                    
                        <?php $__errorArgs = ['father_job'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="mother_name">Mother's Name</label>
                        <input type="text" name="mother_name" id="mother_name" class="form-control" value="<?php echo e(old('mother_name', $student->mother_name)); ?>" required>
                    
                        <?php $__errorArgs = ['mother_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="mother_job">Mother's Job</label>
                        <input type="text" name="mother_job" id="mother_job" class="form-control" value="<?php echo e(old('mother_job', $student->mother_job)); ?>" required>
                    
                        <?php $__errorArgs = ['mother_job'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="date_of_birth">Date of Birth</label>
                        <input type="date" name="date_of_birth" id="date_of_birth" class="form-control" value="<?php echo e(old('date_of_birth', $student->date_of_birth)); ?>" required>
                    
                        <?php $__errorArgs = ['date_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="religion">Religion</label>
                        <select name="religion" id="religion" class="form-control" required>
                            <option value="muslim" <?php echo e(old('religion', $student->religion) == 'muslim' ? 'selected' : ''); ?>>Muslim</option>
                            <option value="christian" <?php echo e(old('religion', $student->religion) == 'christian' ? 'selected' : ''); ?>>Christian</option>
                        </select>

                        <?php $__errorArgs = ['religion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="gender">Gender</label>
                        <select name="gender" id="gender" class="form-control" required>
                            <option value="male" <?php echo e(old('gender', $student->gender) == 'male' ? 'selected' : ''); ?>>Male</option>
                            <option value="female" <?php echo e(old('gender', $student->gender) == 'female' ? 'selected' : ''); ?>>Female</option>
                        </select>

                        <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Address Information -->
                    <div class="mb-3">
                        <label for="address">Address</label>
                        <textarea name="address" id="address" class="form-control" required><?php echo e(old('address', $student->address)); ?></textarea>
                    
                        <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="district">District/Area</label>
                        <input type="text" name="district" id="district" class="form-control" value="<?php echo e(old('district', $student->district)); ?>" required>
                    
                        <?php $__errorArgs = ['district'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="nationality">Nationality</label>
                        <input type="text" name="nationality" id="nationality" class="form-control" value="<?php echo e(old('nationality', $student->nationality)); ?>" required>
                    
                        <?php $__errorArgs = ['nationality'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="place_of_birth">Place of Birth</label>
                        <input type="text" name="place_of_birth" id="place_of_birth" class="form-control" value="<?php echo e(old('place_of_birth', $student->place_of_birth)); ?>" required>
                    
                        <?php $__errorArgs = ['place_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="birth_date">Birth Date</label>
                        <input type="date" name="birth_date" id="birth_date" class="form-control" value="<?php echo e(old('birth_date', $student->birth_date)); ?>" required>
                    
                        <?php $__errorArgs = ['birth_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="national_id">National ID</label>
                        <input type="text" name="national_id" id="national_id" class="form-control" value="<?php echo e(old('national_id', $student->national_id)); ?>" required>
                    
                        <?php $__errorArgs = ['national_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="year_of_entry">Year of Entry</label>
                        <input type="number" name="year_of_entry" id="year_of_entry" class="form-control" value="<?php echo e(old('year_of_entry', $student->year_of_entry)); ?>" required>
                    
                        <?php $__errorArgs = ['year_of_entry'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Transfer Information -->
                    <div class="mb-3">
                        <label for="is_transferred">Is the student transferred from another school?</label>
                        <select name="is_transferred" id="is_transferred" class="form-control" required>
                            <option value="0" <?php echo e(old('is_transferred', $student->is_transferred) == '0' ? 'selected' : ''); ?>>No</option>
                            <option value="1" <?php echo e(old('is_transferred', $student->is_transferred) == '1' ? 'selected' : ''); ?>>Yes</option>
                        </select>
                    
                        <?php $__errorArgs = ['is_transferred'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3" id="former_school_name_container" style="display: <?php echo e(old('is_transferred', $student->is_transferred) == '1' ? 'block' : 'none'); ?>;">
                        <label for="former_school_name">Former School Name</label>
                        <input type="text" name="former_school_name" id="former_school_name" class="form-control" value="<?php echo e(old('former_school_name', $student->former_school_name)); ?>">
                    
                        <?php $__errorArgs = ['former_school_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- File Uploads -->
                    <div class="mb-3">
                        <label for="photo">Student Photo (optional)</label>
                        <input type="file" name="photo" id="photo" class="form-control-file">
                        <?php if($student->photo_path): ?>
                            <img src="<?php echo e(asset('storage/' . $student->photo_path)); ?>" alt="Student Photo" class="mt-2" width="100">
                        <?php endif; ?>
                    
                        <?php $__errorArgs = ['photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="birth_certificate">Birth Certificate (optional)</label>
                        <input type="file" name="birth_certificate" id="birth_certificate" class="form-control-file">
                        <?php if($student->birth_certificate_path): ?>
                            <img src="<?php echo e(asset('storage/' . $student->birth_certificate_path)); ?>" alt="Birth Certificate" class="mt-2" width="100">
                        <?php endif; ?>
                    
                        <?php $__errorArgs = ['birth_certificate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                     <!-- Contacts Section -->
                    <h4>Contacts</h4>

                    <button type="button" class="btn btn-secondary" onclick="addContact()">Add Contact</button>

                    <div id="contacts-section">
                        <?php $__currentLoopData = $student->contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="contact-group">
                                <div class="form-group">
                                    <label for="contacts[<?php echo e($index); ?>][contact_number]">Contact Number</label>
                                    <input type="text" name="contacts[<?php echo e($index); ?>][contact_number]" class="form-control" value="<?php echo e($contact->contact_number); ?>" required>
                                </div>
                                <div class="form-group">
                                    <label for="contacts[<?php echo e($index); ?>][type]">Type</label>
                                    <select name="contacts[<?php echo e($index); ?>][type]" class="form-control" required>
                                        <option value="home" <?php echo e($contact->type == 'home' ? 'selected' : ''); ?>>Home</option>
                                        <option value="mobile" <?php echo e($contact->type == 'mobile' ? 'selected' : ''); ?>>Mobile</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="contacts[<?php echo e($index); ?>][owned_by]">Owned By</label>
                                    <select name="contacts[<?php echo e($index); ?>][owned_by]" class="form-control" required>
                                        <option value="father" <?php echo e($contact->owned_by == 'father' ? 'selected' : ''); ?>>Father</option>
                                        <option value="mother" <?php echo e($contact->owned_by == 'mother' ? 'selected' : ''); ?>>Mother</option>
                                        <option value="other" <?php echo e($contact->owned_by == 'other' ? 'selected' : ''); ?>>Other</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="contacts[<?php echo e($index); ?>][notes]">Notes (optional)</label>
                                    <textarea name="contacts[<?php echo e($index); ?>][notes]" class="form-control"><?php echo e($contact->notes); ?></textarea>
                                </div>
                                <button type="button" class="btn btn-danger" onclick="removeContact(this)">Remove</button>
                                <hr>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!-- Sibling Relationships -->
                    <div class="mb-3">
                        <label for="sibling_search" class="form-label">Siblings (Select Multiple)</label>
                        <input type="text" id="sibling_search" class="form-control" placeholder="Type to search siblings">
                        
                        <!-- Container for displaying selected siblings -->
                        <div id="selected_siblings" class="mt-2">
                            <?php $__currentLoopData = $student->siblings()->whereNull('deleted_at')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sibling): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge bg-primary me-1 sibling-tag" data-id="<?php echo e($sibling->id); ?>">
                                    <?php echo e($sibling->name); ?> <i class="ti ti-close" onclick="removeSibling(<?php echo e($sibling->id); ?>)"></i>
                                </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <!-- Hidden input to store selected sibling IDs -->
                        <input type="hidden" name="sibling_ids" id="sibling_ids" value="<?php echo e($student->siblings()->whereNull('deleted_at')->pluck('id')->implode(',')); ?>">
                    </div>

                    <!-- Associations -->
                    <div class="mb-3">
                        <label for="grade_id">Grade</label>
                        <select name="grade_id" id="grade_id" class="form-control" required>
                            <?php $__currentLoopData = $grades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($grade->id); ?>" <?php echo e(old('grade_id', $student->grade_id) == $grade->id ? 'selected' : ''); ?>>
                                    <?php echo e($grade->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <?php $__errorArgs = ['grade_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="school_id">School</label>
                        <select name="school_id" id="school_id" class="form-control" required>
                            <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($school->id); ?>" <?php echo e(old('school_id', $student->school_id) == $school->id ? 'selected' : ''); ?>>
                                    <?php echo e($school->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <?php $__errorArgs = ['school_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="neighborhood_id">Neighborhood</label>
                        <select name="neighborhood_id" id="neighborhood_id" class="form-control" required>
                            <?php $__currentLoopData = $neighborhoods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $neighborhood): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($neighborhood->id); ?>" <?php echo e(old('neighborhood_id', $student->neighborhood_id) == $neighborhood->id ? 'selected' : ''); ?>>
                                    <?php echo e($neighborhood->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <?php $__errorArgs = ['neighborhood_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="mb-3">
                        <label for="note" class="form-label">Add a Note (optional)</label>
                        <textarea name="note" class="form-control" rows="3"><?php echo e(old('note')); ?></textarea>
                    </div>

                    <!-- Display existing notes -->
                    <?php if($student->notes->isNotEmpty()): ?>
                        <div class="mt-4">
                            <h5>Existing Notes</h5>
                            <ul class="list-group">
                                <?php $__currentLoopData = $student->notes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="list-group-item">
                                        <?php echo e($note->content); ?> <br>
                                        <small>Added by: <a href="<?php echo e(route('users.show', $note->user->id)); ?>"><?php echo e($note->user->name); ?></a> on <?php echo e($note->created_at->format('d M, Y')); ?></small>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-check me-1"></span> Update Student
                </button>
            </div>
        </div>
    </form>

    <script>
        // Toggle former school name based on transfer status
        document.getElementById('is_transferred').addEventListener('change', function () {
            const formerSchoolNameContainer = document.getElementById('former_school_name_container');
            if (this.value === '1') {
                formerSchoolNameContainer.style.display = 'block';
                document.getElementById('former_school_name').setAttribute('required', 'required');
            } else {
                formerSchoolNameContainer.style.display = 'none';
                document.getElementById('former_school_name').removeAttribute('required');
            }
        });

        // Add a new contact dynamically
        function addContact() {
            const container = document.getElementById('contacts-section');
            const index = container.children.length;

            container.insertAdjacentHTML('beforeend', `
                <div class="contact-group">
                    <div class="form-group">
                        <label for="contacts[${index}][contact_number]">Contact Number</label>
                        <input type="text" name="contacts[${index}][contact_number]" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="contacts[${index}][type]">Type</label>
                        <select name="contacts[${index}][type]" class="form-control" required>
                            <option value="home">Home</option>
                            <option value="mobile">Mobile</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="contacts[${index}][owned_by]">Owned By</label>
                        <select name="contacts[${index}][owned_by]" class="form-control" required>
                            <option value="father">Father</option>
                            <option value="mother">Mother</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="contacts[${index}][notes]">Notes (optional)</label>
                        <textarea name="contacts[${index}][notes]" class="form-control"></textarea>
                    </div>
                    <button type="button" class="btn btn-danger" onclick="removeContact(this)">Remove</button>
                    <hr>
                </div>
            `);
        }

        // Remove a contact dynamically
        function removeContact(button) {
            button.closest('.contact-group').remove();
        }

        // On page load, check the value of 'is_transferred' to set the correct display state
        document.addEventListener('DOMContentLoaded', function() {
            const isTransferred = document.getElementById('is_transferred').value;
            const formerSchoolNameContainer = document.getElementById('former_school_name_container');
            if (isTransferred === '1') {
                formerSchoolNameContainer.style.display = 'block';
                document.getElementById('former_school_name').setAttribute('required', 'required');
            } else {
                formerSchoolNameContainer.style.display = 'none';
                document.getElementById('former_school_name').removeAttribute('required');
            }
        });

        // Student Siblings Script
        $(document).ready(function() {
            // Initialize the Select2 or jQuery autocomplete (you can use jQuery UI Autocomplete or Select2)
            $('#sibling_search').select2({
                placeholder: 'Type to search siblings',
                ajax: {
                    url: '<?php echo e(route("students.siblings.search")); ?>',
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            query: params.term // search term
                        };
                    },
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (item) {
                                return {
                                    id: item.id,
                                    text: item.name
                                };
                            })
                        };
                    },
                    cache: true
                }
            });

            // Handling sibling selection
            $('#sibling_search').on('select2:select', function(e) {
                var data = e.params.data;

                // Append selected sibling as a tag
                $('#selected_siblings').append(
                    `<span class="badge bg-primary me-1 sibling-tag" data-id="${data.id}">
                        ${data.text} <i class="ti ti-close" onclick="removeSibling(${data.id})"></i>
                    </span>`
                );

                // Update hidden input with selected sibling IDs
                updateSiblingIds();
            });
        });

        // Function to remove a sibling tag
        function removeSibling(id) {
            $(`.sibling-tag[data-id="${id}"]`).remove();
            updateSiblingIds();
        }

        // Function to update hidden input with selected sibling IDs
        function updateSiblingIds() {
            var selectedIds = [];
            $('.sibling-tag').each(function() {
                selectedIds.push($(this).data('id'));
            });
            $('#sibling_ids').val(selectedIds.join(','));
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\students\edit.blade.php ENDPATH**/ ?>