<?php $__env->startSection('title', isset($announcement) ? 'Edit Announcement' : 'Create Announcement'); ?>

<?php $__env->startSection('content'); ?>
    <!-- If editing, we use the PUT method, else POST for creating -->
    <form method="POST" action="<?php echo e(isset($announcement) ? route('admin.announcements.update', $announcement->id) : route('admin.announcements.store')); ?>">
        <?php echo csrf_field(); ?>

        <?php if(isset($announcement)): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
          
        <h4><?php echo e(isset($announcement) ? 'Edit' : 'Create'); ?> Announcement</h4>

        <div class="col-12 col-lg-8">
            <!-- School  Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">Announcement Information</h5>
                </div>

                <div class="card-body">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <!-- Title field -->
                    <div class="mb-3">
                        <label for="title">Title:</label>

                        <input type="text" id="title" class="form-control" name="title" value="<?php echo e(old('title', $announcement->title ?? '')); ?>" required>
                    
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <!-- Message field -->
                    <div class="mb-3">
                        <label for="message">Message:</label>
                        
                        <textarea id="message" class="form-control" name="message" required><?php echo e(old('message', $announcement->message ?? '')); ?></textarea>
                    
                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red;"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Type field -->
                    <div class="mb-3">
                        <label for="type">Type:</label>

                        <select id="type" name="type" class="form-control" required>
                            <option value="normal" <?php echo e(old('type', $announcement->type ?? '') == 'normal' ? 'selected' : ''); ?>>Normal</option>
                            <option value="information" <?php echo e(old('type', $announcement->type ?? '') == 'information' ? 'selected' : ''); ?>>Information</option>
                            <option value="warning" <?php echo e(old('type', $announcement->type ?? '') == 'warning' ? 'selected' : ''); ?>>Warning</option>
                            <option value="success" <?php echo e(old('type', $announcement->type ?? '') == 'success' ? 'selected' : ''); ?>>Success</option>
                        </select>
                    </div>

                    <!-- End date field -->
                    <div class="mb-3">
                        <label for="end_date">End Date (optional):</label>

                        <input type="date" id="end_date" class="form-control" name="end_date" value="<?php echo e(old('end_date', $announcement->end_date ?? '')); ?>">
                    </div>

                    <!-- Permanent field -->
                    <div class="mb-3">
                        <input type="hidden" name="is_permanent" value="0"> <!-- Hidden input for unchecked state -->
                        <label for="permanent">
                            <input type="checkbox" id="permanent" name="is_permanent" value="1" 
                                <?php echo e(old('is_permanent', $announcement->is_permanent ?? false) ? 'checked' : ''); ?>>
                            Permanent
                        </label>
                    </div>

                    <!-- Users selection for assigning announcements -->
                    <div class="mb-3">
                        <label for="users">Assign to Specific Users (optional):</label>

                        <select id="users" name="users[]" class="form-control" multiple>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>" 
                                    <?php echo e(isset($announcement) && $announcement->users->contains($user->id) ? 'selected' : ''); ?>>
                                    <?php echo e($user->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-plus me-1"></span> <?php echo e(isset($announcement) ? 'Update' : 'Create'); ?> Announcement
                </button>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\announcements\form.blade.php ENDPATH**/ ?>