<?php

use Illuminate\Support\Facades\Route;
use App\Http\Middleware\App\CheckInstallation;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Apply the middleware directly to specific routes
Route::middleware([CheckInstallation::class])->group(function () {
    // Include all route files from the "system" folder first
    foreach (glob(base_path('routes/app/system/*.php')) as $file) {
        require $file;
    }

    // Include all route files from the "backend" folder next
    foreach (glob(base_path('routes/app/backend/*.php')) as $file) {
        require $file;
    }

    // Include all route files from the "frontend" folder last
    foreach (glob(base_path('routes/app/frontend/*.php')) as $file) {
        require $file;
    }
});