<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\System\InstallationController;

// Public or installation routes that don't need the EnsureSuperAdmin middleware
Route::get('/install', [InstallationController::class, 'index'])->name('install.index');
Route::post('/install/build-database', [InstallationController::class, 'buildDatabase'])->name('install.buildDatabase');
Route::post('/install/setup', [InstallationController::class, 'setup'])->name('install.setup');
Route::get('/install/settings', [InstallationController::class, 'getDefaultSettings'])->name('install.get.default.settings');
Route::post('/install/settings', [InstallationController::class, 'storeDefaultSettings'])->name('install.store.default.Settings');
Route::get('/install/complete', [InstallationController::class, 'complete'])->name('install.complete');