<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Dashboard\HomeController;
use App\Http\Controllers\Dashboard\MediaController;
use App\Http\Controllers\Dashboard\RoleController;
use App\Http\Controllers\Dashboard\PermissionController;
use App\Http\Controllers\Dashboard\UserController;
use App\Http\Controllers\Dashboard\LogController;
use App\Http\Controllers\Dashboard\PageController;
use App\Http\Controllers\Dashboard\AnnouncementController;
use App\Http\Controllers\Dashboard\SchoolController;
use App\Http\Controllers\Dashboard\GradeController;
use App\Http\Controllers\Dashboard\DistrictController;
use App\Http\Controllers\Dashboard\NeighborhoodController;
use App\Http\Controllers\Dashboard\StudentController;
use App\Http\Controllers\Dashboard\SettingController;
use App\Http\Controllers\Dashboard\InvitationController;

// Admin Routes Group in Guest middlware
Route::prefix('admin')->middleware('guest:admin')->name('admin.')->group(function () {
    // Redirect /admin to /admin/login
    Route::get('/', function () {
        return redirect()->route('admin.login');
    });
});

// Grouping under /admin and applying admin middleware and make sure admin status is active
Route::prefix('admin')->middleware('auth:admin', 'active')->name('admin.')->group(function () {
    // Dashboard page
    Route::get('/dashboard', [HomeController::class, 'index'])->name('dashboard');

    // Media library routes
    Route::prefix('media')->name('media.')->group(function () {
        Route::post('upload', [MediaController::class, 'upload'])->name('upload');
        Route::get('library', [MediaController::class, 'index'])->name('library');
        Route::get('library/ajax', [MediaController::class, 'getMediaLibraryAjax'])->name('library.ajax');
        Route::post('edit/{media}', [MediaController::class, 'edit'])->name('edit');
        Route::delete('delete/{media}', [MediaController::class, 'destroy'])->name('delete');
    });

    // Routes for Role Management
    Route::resource('roles', RoleController::class);

    // Routes for Permission Management
    Route::resource('permissions', PermissionController::class);

    // Group Users Routes Under /admin/users
    Route::resource('users', UserController::class);
    Route::patch('/users/{user}/activate', [UserController::class, 'activate'])->name('users.activate');
    Route::patch('/users/{user}/deactivate', [UserController::class, 'deactivate'])->name('users.deactivate');

    // Group Logs Routes Under /admin/logs
    Route::prefix('logs')->name('logs.')->group(function () {
        Route::get('/', [LogController::class, 'index'])->name('index');
        Route::get('/export', [LogController::class, 'export'])->name('export');
        Route::post('/clear', [LogController::class, 'clear'])->name('clear');
    });

    // Group Pages Routes Under /admin/pages
    Route::prefix('pages')->name('pages.')->group(function () {
         // CRUD Routes for Pages
        Route::resource('/', PageController::class);

        // Route to view trashed pages
        Route::get('/trashed', [PageController::class, 'trashed'])->name('trashed');

        // Restore trashed page
        Route::post('/{id}/restore', [PageController::class, 'restore'])->name('restore');

        // Permanently delete page
        Route::delete('/{id}/forceDelete', [PageController::class, 'forceDelete'])->name('forceDelete');

        // AJAX route for checking slug uniqueness
        Route::get('/check-slug', [PageController::class, 'checkSlug'])->name('checkSlug');
    });

    // Group Announcements Routes Under /admin/announcements
    Route::prefix('announcements')->name('announcements.')->group(function () {
        // Announcement CRUD routes (only accessible by Super Admin or specific roles)
        Route::resource('', AnnouncementController::class)->middleware('auth');

        // Route to mark announcement as seen by the user
        Route::post('/{announcement}/seen', [AnnouncementController::class, 'markAsSeen'])->middleware('auth')->name('markAsSeen');
    });

    // Routes for Grades Management
    Route::resource('/grades', GradeController::class);

    // Routes for Districts Management
    Route::resource('/districts', DistrictController::class);

    // Routes for Neighborhoods Management
    Route::resource('/neighborhoods', NeighborhoodController::class);

    // Group Schools Routes Under /admin/schools
    Route::resource('schools', SchoolController::class); // Routes for Schools Management

    Route::prefix('schools')->name('schools.')->group(function () {
        // Restore trashed school
        Route::patch('/{id}/restore', [SchoolController::class, 'restore'])->name('restore');

        // Permanently delete school
        Route::delete('/{id}/forceDelete', [SchoolController::class, 'forceDelete'])->name('forceDelete');
    });

    // Group Students Routes Under /admin/students
    Route::resource('students', StudentController::class); // Routes for Students Management

    Route::prefix('students')->name('students.')->group(function () {
        // Restore trashed student
        Route::post('/{id}/restore', [StudentController::class, 'restore'])->name('restore');

        // Permanently delete trashed student
        Route::delete('/{id}/forceDelete', [StudentController::class, 'forceDelete'])->name('forceDelete');

        // Route for trashed students (soft deleted)
        Route::get('/trashed', [StudentController::class, 'trashed'])->name('trashed');

        // Route for student sibling search for autocomplete
        Route::get('/siblings/search', [StudentController::class, 'searchSiblings'])->name('siblings.search');
    });

    // Group Settings Routes Under /admin/settings
    Route::prefix('settings')->name('settings.')->group(function () {
        // List settings of a specific group
        Route::get('/group/{group}', [SettingController::class, 'index'])->name('index');

        // Create a new setting in a specific group
        Route::get('/create', [SettingController::class, 'create'])->name('create');

        // Store a new setting in a specific group
        Route::post('/create', [SettingController::class, 'store'])->name('store');

        // Update a specific setting
        Route::post('/update', [SettingController::class, 'update'])->name('update');
    });

    // Group ÷nvitations Routes Under /admin/invitations
    Route::prefix('invitations')->name('invitations.')->group(function () {
        Route::get('/', [InvitationController::class, 'index'])->name('index');
        Route::post('/', [InvitationController::class, 'store'])->name('store');
        Route::get('/create', [InvitationController::class, 'create'])->name('create');
        Route::get('/accept/{token}', [InvitationController::class, 'acceptInvitation'])->name('accept');
    });
});