<script src="https://cdnjs.cloudflare.com/ajax/libs/pusher/7.0.3/pusher.min.js"></script>

@php
$menuCollapsed = ($configData['menuCollapsed'] === 'layout-menu-collapsed') ? json_encode(true) : false;
@endphp

<!-- laravel style -->
@vite(['resources/assets/vendor/js/helpers.js'])

<!-- beautify ignore:start -->
@if ($configData['hasCustomizer'])
  <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
  <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->
  @vite(['resources/assets/vendor/js/template-customizer.js'])
@endif

<!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
@vite(['resources/assets/js/config.js'])

@if ($configData['hasCustomizer'])
    <script type="module">
        window.templateCustomizer = new TemplateCustomizer({
            cssPath: '',
            themesPath: '',
            defaultStyle: "{{$configData['styleOpt']}}",
            defaultShowDropdownOnHover: "{{$configData['showDropdownOnHover']}}", // true/false (for horizontal layout only)
            displayCustomizer: "{{$configData['displayCustomizer']}}",
            lang: '{{ app()->getLocale() }}',
            pathResolver: function(path) {
                var resolvedPaths = {
                    // Core stylesheets
                    @foreach (['core'] as $name)
                    '{{ $name }}.scss': '{{ Vite::asset('resources/assets/vendor/scss'.$configData["rtlSupport"].'/'.$name.'.scss') }}',
                    '{{ $name }}-dark.scss': '{{ Vite::asset('resources/assets/vendor/scss'.$configData["rtlSupport"].'/'.$name.'-dark.scss') }}',
                    @endforeach

                    // Themes
                    @foreach (['default', 'bordered', 'semi-dark'] as $name)
                    'theme-{{ $name }}.scss': '{{ Vite::asset('resources/assets/vendor/scss'.$configData["rtlSupport"].'/theme-'.$name.'.scss') }}',
                    'theme-{{ $name }}-dark.scss': '{{ Vite::asset('resources/assets/vendor/scss'.$configData["rtlSupport"].'/theme-'.$name.'-dark.scss') }}',
                    @endforeach
                }
                return resolvedPaths[path] || path;
            },
            'controls': <?php echo json_encode($configData['customizerControls']); ?>,
        });
    </script>
@endif

<script>
    let idleTime = 0;
    const maxIdleTime = 30; // 30 minutes of inactivity

    // Increment the idle time every minute
    setInterval(timerIncrement, 60000); // 1 minute interval

    // Reset idle time when there is activity
    window.onload = resetTimer;
    window.onmousemove = resetTimer;
    window.onkeypress = resetTimer;

    function resetTimer() {
        idleTime = 0;
    }

    function timerIncrement() {
        idleTime++;
        if (idleTime >= maxIdleTime) {
            // User has been inactive for more than maxIdleTime minutes
            // Send an AJAX request to log the user out or update status
            $.ajax({
                url: '/logout',  // Or a custom route to just update the user's status
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                success: function() {
                    window.location.reload(); // Optionally reload the page after logout
                }
            });
        }
    }
</script>

<script>
    window.Echo.join('user-status')
        .here((users) => {
            console.log('Users currently online:', users);
        })
        .joining((user) => {
            console.log(user.name + ' is now online.');
            // Update the UI to reflect the user is online
            document.getElementById('user-' + user.user_id).innerHTML = 'Online';
        })
        .leaving((user) => {
            console.log(user.name + ' is now offline.');
            // Update the UI to reflect the user is offline
            document.getElementById('user-' + user.user_id).innerHTML = 'Offline';
        })
        .listen('UserOnlineStatusChanged', (e) => {
            console.log('User status changed:', e);
        });
</script>