@php
    $customizerHidden = 'customizer-hide';
    $configData = Helper::appClasses();
@endphp

@extends('layouts/blankLayout')

@section('title', 'Landing - Front Pages')

<!-- Vendor Styles -->
@section('vendor-style')
    @vite(['resources/assets/vendor/libs/nouislider/nouislider.scss', 'resources/assets/vendor/libs/swiper/swiper.scss'])
@endsection

<!-- Page Styles -->
@section('page-style')
    @vite(['resources/assets/vendor/scss/pages/front-page-landing.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/nouislider/nouislider.js', 'resources/assets/vendor/libs/swiper/swiper.js'])
@endsection

<!-- Page Scripts -->
@section('page-script')
    @vite(['resources/assets/js/front-page-landing.js'])
@endsection

@section('content')
    <div data-bs-spy="scroll" class="scrollspy-example">
        <!-- Hero: Start -->
        <section id="hero-animation">
            <div id="landingHero" class="section-py landing-hero position-relative">
                <img src="{{ asset('assets/img/front-pages/backgrounds/hero-bg.png') }}" alt="hero background"
                    class="position-absolute top-0 start-50 translate-middle-x object-fit-contain w-100 h-100"
                    data-speed="1" />

                <div class="container">
                    <div class="hero-text-box text-center">
                        <h1 class="text-primary hero-title display-6 fw-bold">Installation was successfull!</h1>

                        <h2 class="hero-sub-title h6 mb-4 pb-1">
                            The database has been successfully built, and your system is ready to use.<br
                                class="d-none d-lg-block" />
                            Now you are ready to go, thank you for your patience.
                        </h2>

                        <div class="landing-hero-btn d-inline-block position-relative">
                            <span class="hero-btn-item position-absolute d-none d-md-flex text-heading">You're ready!

                                <img src="{{ asset('assets/img/front-pages/icons/Join-community-arrow.png') }}"
                                    alt="Join community arrow" class="scaleX-n1-rtl" /></span>

                            <a href="{{ route('front.pages.home') }}" class="btn btn-primary btn-lg"><span
                                    class="ti-xs ti ti-home me-1"></span> Homepage</a>
                            <a href="{{ route('admin.login') }}" class="btn btn-primary btn-lg"><span
                                    class="ti-xs ti ti-dashboard me-1"></span> Admin Dashboard</a>
                            {{-- <form id="build-db-form" method="POST" action="{{ route('install.buildDatabase') }}">
                                @csrf
                                
                                <a href="{{ url('/') }}" class="btn btn-primary btn-lg">Go to Homepage</a>
                            </form> --}}
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Hero: End -->
    </div>

    <style>
        .landing-hero .landing-hero-btn .hero-btn-item {
            inset-inline-start: -40%;
        }
    </style>
@endsection
