@extends('layouts/layoutMaster')

@section('title', $user->name)

@section('content')
    <div class="col-12 col-lg-12">
        <!-- Role Information -->

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-tile mb-0">{{ $user->name }}</h5>
            </div>

            <div class="card-body">
                <div class="mb-3">
                    <label>User Information:</label>

                    <ul>
                        <li>Email Address : {{ $user->email }}</li>
                        <li>Gender : {{ $user->gender }}</li>
                        <li>Phone : {{ $user->phone }}</li>
                        <li>
                            @if (isset($user) && $user->photo)
                                <img src="{{ asset('images/' . $user->photo) }}" width="100" alt="User Photo">
                            @endif
                        </li>
                        <li>About : {{ $user->about }}</li>
                        <li>Position : {{ $user->position }}</li>
                        <li>Hired Date : {{ $user->hired_date }}</li>
                        <li>Department : {{ $user->department }}</li>
                    </ul>

                    <a href="{{ route('admin.users.index') }}" class="btn btn-primary">Back to Users</a>
                </div>
            </div>
        </div>
    </div>
@endsection
