@extends('layouts/layoutMaster')

@section('title', isset($user) ? 'Edit User' : 'Create User')

@section('content')
    <form action="{{ isset($user) ? route('admin.users.update', ['user', $user->id]) : route('admin.users.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        @if(isset($user))
            @method('PUT')
        @endif

        <div class="col-12 col-lg-8">
            <!-- User Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">{{ isset($user) ? 'Edit User' : 'Create User' }}</h5>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="mb-3">
                        <label class="form-label" for="full-name">Full Name</label>
                        
                        <input type="text" class="form-control" id="full-name" placeholder="Full Name" name="name" aria-label="Full Name" value="{{ $user->name ?? old('name') }}" required />
                        
                        @error('name')
                            <div style="color: red; font-weight: bold"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="email-address">Email Address</label>
                        
                        <input type="email" class="form-control" id="email-address" placeholder="Email Address" name="email" aria-label="Email Address" value="{{ $user->email ?? old('email') }}" required />
                        
                        @error('email')
                            <div style="color: red; font-weight: bold"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="roles">Gender</label>
                        <select class="form-control" id="gender" name="gender">
                            <option value="male" @if(isset($user) && $user->gender == 'male') selected @endif>Male</option>
                            <option value="female" @if(isset($user) && $user->gender == 'female') selected @endif>Female</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="phone">Phone</label>
                        <input type="text" class="form-control" id="phone" name="phone" value="{{ $user->phone ?? old('phone') }}">
                    </div>
        
                    <div class="mb-3">
                        <label for="photo">Photo</label>

                        <input type="file" class="form-control-file" id="photo" name="photo">

                        @if (isset($user) && $user->photo)
                            <img src="{{ asset('images/' . $user->photo) }}" width="100" alt="User Photo">
                        @endif
                    </div>

                    <!-- Roles Select -->
                    <!-- Super Admin role should not be removed -->
                    @if (!$user->hasRole('Super Admin'))
                        <div class="mb-3">
                            <label for="roles">Assign Roles</label>
                            <select class="form-control" id="roles" name="roles[]" multiple>
                                @foreach($roles as $role)
                                    <option value="{{ $role->id }}" @if(isset($user) && $user->roles->contains($role->id)) selected @endif>
                                        {{ $role->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    @else
                        <div class="mb-3">
                            <label for="roles">Assigned Roles</label>
                            <input type="text" class="form-control" value="Super Admin" disabled>
                            <input type="hidden" name="roles[]" value="{{ $superAdminRole->id }}">
                        </div>
                    @endif

                    <div class="mb-3">
                        <label for="roles">About you (optional - but you can write small biography so your collegues know more of yourself)</label>
                        <textarea class="form-control" id="about" name="about">{{ $user->about ?? old('about') }}</textarea>
                    </div>

                    <div class="mb-3">
                        <label for="position">Position</label>
                        <input type="text" name="position" class="form-control" value="{{ $user->position ?? old('position') }}">
                    </div>

                    <div class="mb-3">
                        <label for="hired_date">Hired Date</label>
                        <input type="date" name="hired_date" class="form-control" value="{{ $user->hired_date ?? old('hired_date') }}">
                    </div>

                    <div class="mb-3">
                        <label for="department">Department</label>
                        <input type="text" name="department" class="form-control" value="{{ $user->department ?? old('department') }}">
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-check me-1"></span> {{ isset($user) ? 'Update' : 'Create' }} User
                </button>
            </div>
        </div>
    </form>
@endsection