@extends('layouts/layoutMaster')

@section('title', 'Trashed Students')

@section('content')
    <h4>Trashed Students</h4>

    <div class="card">
        <h5 class="card-header">Schools Table</h5>

        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            <div class="table-responsive text-nowrap">
            @if(!$students->isEmpty())
                    <table class="table table-bordered table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Actions</th>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach($students as $student)
                                <tr>
                                    <td>{{ $student->id }}</td>
                                    <td>{{ $student->name }}</td>
                                    <td>{{ $student->email }}</td>
                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </button>

                                            <a class="dropdown-item" href="{{ route('students.restore', $student->id) }}">
                                                <i class="ti ti-pencil me-1"></i>
                                                Restore
                                            </a>

                                            <form action="{{ route('students.forceDelete', $student->id) }}" method="POST"  id="deleteForm{{ $student->id }}" style="display:inline;">
                                                @csrf
                                                @method('DELETE')

                                                <button type="submit" class="dropdown-item btn btn-danger" onclick="confirmDelete('{{ $student->id }}')">
                                                    <i class="ti ti-trash me-1"></i>
                                                    Delete Permanently
                                                </button>
                                            </form>
                                        </div>

                                        <!-- SweetAlert script -->
                                        <script>
                                            function confirmDelete(studentId) {
                                                Swal.fire({
                                                    title: 'Are you sure?',
                                                    text: 'You want to delete this student! There might be related information for this student',
                                                    icon: 'warning',
                                                    showCancelButton: true,
                                                    confirmButtonColor: '#d33',
                                                    cancelButtonColor: '#3085d6',
                                                    confirmButtonText: 'Yes, delete student!'
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        document.getElementById('deleteForm' + studentId).submit();
                                                    }
                                                });
                                            }
                                        </script>
                                        
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    
                    { $students->links() }}
                @else
                    <p>No trashed students found.</p>
                @endif
            </div>
        </div>
    </div>
@endsection