@extends('layouts/layoutMaster')

@section('title', 'Student Profile')

@section('content')
    <div class="col-12 col-lg-12">
        <!-- Student Information -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-tile mb-0">Student Profile</h5>
            </div>

            @if (session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-4">
                        <!-- Display student photo if available -->
                        @if($student->photo_path)
                            <img src="{{ asset('storage/' . $student->photo_path) }}" alt="Student Photo" class="img-fluid rounded mb-3">
                        @else
                            <img src="{{ asset('images/default-profile.png') }}" alt="Default Photo" class="img-fluid rounded mb-3">
                        @endif
                    </div>

                    <div class="col-md-8">
                        <h4>Basic Information</h4>

                        <p><strong>Full Name:</strong> {{ $student->full_name }}</p>
                        <p><strong>Father's Name:</strong> {{ $student->father_name }}</p>
                        <p><strong>Father's Job:</strong> {{ $student->father_job }}</p>
                        <p><strong>Mother's Name:</strong> {{ $student->mother_name }}</p>
                        <p><strong>Mother's Job:</strong> {{ $student->mother_job }}</p>
                        <p><strong>Date of Birth:</strong> {{ $student->date_of_birth }}</p>
                        <p><strong>Religion:</strong> {{ ucfirst($student->religion) }}</p>
                        <p><strong>Gender:</strong> {{ ucfirst($student->gender) }}</p>
                        <p><strong>National ID:</strong> {{ $student->national_id }}</p>
                    </div>
                </div>

                <h4>Address Information</h4>

                <p><strong>Address:</strong> {{ $student->address }}</p>
                <p><strong>District/Area:</strong> {{ $student->district }}</p>
                <p><strong>Place of Birth:</strong> {{ $student->place_of_birth }}</p>
                <p><strong>Nationality:</strong> {{ $student->nationality }}</p>

                <h4>School Information</h4>

                <p><strong>Grade:</strong> {{ $student->grade->name }}</p>
                <p><strong>School:</strong> {{ $student->school->name }}</p>
                <p><strong>Neighborhood:</strong> {{ $student->neighborhood->name }}</p>
                <p><strong>Year of Entry:</strong> {{ $student->year_of_entry }}</p>
                <p><strong>Is Transferred:</strong> {{ $student->is_transferred ? 'Yes' : 'No' }}</p>

                @if($student->is_transferred)
                    <p><strong>Former School Name:</strong> {{ $student->former_school_name }}</p>
                @endif

                <h4>Contact Information</h4>

                @forelse ($student->contacts as $contact)
                    <div class="card mb-2">
                        <div class="card-body">
                            <p><strong>Contact Number:</strong> {{ $contact->contact_number }}</p>
                            <p><strong>Type:</strong> {{ ucfirst($contact->type) }}</p>
                            <p><strong>Owned By:</strong> {{ ucfirst($contact->owned_by) }}</p>
                            <p><strong>Notes:</strong> {{ $contact->notes ?? 'N/A' }}</p>
                        </div>
                    </div>
                @empty
                    <p>No contact information available.</p>
                @endforelse

                <h4>Siblings</h4>

                @if($student->siblings->count() > 0)
                    <ul>
                        @foreach ($student->siblings as $sibling)
                            <li>
                                {{ $sibling->full_name }} - Grade: {{ $sibling->grade->name }}
                                <a href="{{ route('admin.students.show', $sibling->id) }}" class="btn btn-link">View Profile</a>
                            </li>
                        @endforeach
                    </ul>
                @else
                    <p>No siblings recorded.</p>
                @endif

                <h4>Additional Files</h4>

                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Birth Certificate:</strong></p>
                        @if($student->birth_certificate_path)
                            <a href="{{ asset('storage/' . $student->birth_certificate_path) }}" target="_blank">View Birth Certificate</a>
                        @else
                            <p>No birth certificate uploaded.</p>
                        @endif
                    </div>
                </div>

                @if ($student->notes->count())
                    <h4>Notes</h4>
                    <ul>
                        @foreach ($student->notes as $note)
                            <li>
                                <strong>{{ $note->user->name }}</strong> ({{ $note->created_at->format('d M Y') }}):
                                {{ $note->note }}
                            </li>
                        @endforeach
                    </ul>
                @endif

                <a href="{{ route('admin.students.edit', $student->id) }}" class="btn btn-warning mt-3">Edit Student</a>

                <form action="{{ route('admin.students.destroy', $student->id) }}" method="POST" class="d-inline-block">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger mt-3" onclick="return confirm('Are you sure you want to delete this student?')">Delete Student</button>
                </form>

                <a href="{{ route('admin.students.index') }}" class="btn btn-primary">Back to all students</a>
            </div>
        </div>
    </div>
@endsection
