@extends('layouts/layoutMaster')

@section('title', 'Students List')

@section('content')
    <h4>Students List</h4>

    <div class="card">
        <h5 class="card-header">Students List</h5>

        <div class="card-body">
            <!-- Display success or error messages -->
            @if (session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            <a href="{{ route('admin.students.create') }}" class="btn btn-primary">Add New Student</a>
            <a href="{{ route('admin.students.trashed') }}" class="btn btn-secondary">View Trashed Students</a>

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>Full Name</th>
                            <th>Grade</th>
                            <th>School</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        @forelse ($students as $student)
                            <tr class="{{ $student->trashed() ? 'table-danger' : '' }}">
                                <td>{{ $student->id }}</td>
                                <td>{{ $student->full_name }}</td>
                                <td>{{ $student->grade->name }}</td>
                                <td>{{ $student->school->name }}</td>
                                <td>
                                    {{ $student->trashed() ? 'Deleted' : 'Active' }}
                                </td>
                                <td>
                                <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <a class="dropdown-item" href="{{ route('admin.students.show', $student->id) }}">
                                            <i class="ti ti-eye me-1"></i>
                                            Student Details
                                        </a>

                                        @if (!$student->trashed())
                                            <a class="dropdown-item" href="{{ route('admin.students.edit', $student->id) }}">
                                                <i class="ti ti-pencil me-1"></i>
                                                Edit
                                            </a>
                                        
                                            <form action="{{ route('admin.students.destroy', $student->id) }}" method="POST" id="deleteForm{{ $student->id }}" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-danger btn-sm" onclick="confirmDelete('{{ $student->id }}', 'trash')" onclick="return confirm('Are you sure?')">Delete</button>
                                            </form>
                                        @else
                                            <form action="{{ route('admin.students.restore', $student->id) }}" method="POST" style="display:inline;">
                                                @csrf
                                                <button type="submit" class="btn btn-success btn-sm">Restore</button>
                                            </form>

                                            <form action="{{ route('admin.students.forceDelete', $student->id) }}" method="POST" id="deleteForm{{ $student->id }}" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="confirmDelete('{{ $student->id }}', 'force')" onclick="return confirm('Permanently delete this student?')">Force Delete</button>
                                            </form>
                                        @endif
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(studentId, type) {
                                            var messge;

                                            if(type == 'trash') {
                                                message = '';
                                            }
                                            else if(type == 'force') {
                                                message = 'You want to delete this student there might be related information to this student';
                                            }
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this student there might be related information to this student',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete this student!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + studentId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6">No students found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>

                {{ $students->links() }}
            </div>
        </div>
    </div>
@endsection