@extends('layouts/layoutMaster')

@section('title', 'Add New Student')

@section('content')
    <form action="{{ route('admin.students.store') }}" method="POST" enctype="multipart/form-data">
        @csrf 
          
        <h4>Add New Student</h4>

        <div class="col-12 col-lg-8">
            <!-- School  Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">Student Information</h5>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <!-- Basic Information -->
                    <div class="mb-3">
                        <label class="form-label" for="full_name">Full Name</label>
                        <input type="text" class="form-control" id="full_name" placeholder="Full Name" name="full_name" aria-label="Full Name"  value="{{ old('full_name') }}" required />
                        
                        @error('full_name')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="father_name">Father's Name</label>
                        <input type="text" name="father_name" id="father_name" class="form-control" value="{{ old('father_name') }}" required>

                        @error('father_name')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="father_job">Father's Job</label>
                        <input type="text" name="father_job" id="father_job" class="form-control" value="{{ old('father_job') }}" required>

                        @error('father_job')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="mother_name">Mother's Name</label>
                        <input type="text" name="mother_name" id="mother_name" class="form-control" value="{{ old('mother_name') }}" required>

                        @error('mother_name')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="mother_job">Mother's Job</label>
                        <input type="text" name="mother_job" id="mother_job" class="form-control" value="{{ old('mother_job') }}" required>

                        @error('mother_job')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="date_of_birth">Date of Birth</label>
                        <input type="date" name="date_of_birth" id="date_of_birth" class="form-control" value="{{ old('date_of_birth') }}" required>

                        @error('date_of_birth')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="religion">Religion</label>
                        <select name="religion" id="religion" class="form-control" required>
                            <option value="muslim" {{ old('religion') == 'muslim' ? 'selected' : '' }}>Muslim</option>
                            <option value="christian" {{ old('religion') == 'christian' ? 'selected' : '' }}>Christian</option>
                        </select>

                        @error('religion')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="gender">Gender</label>
                        <select name="gender" id="gender" class="form-control" required>
                            <option value="male" {{ old('gender') == 'male' ? 'selected' : '' }}>Male</option>
                            <option value="female" {{ old('gender') == 'female' ? 'selected' : '' }}>Female</option>
                        </select>

                        @error('gender')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Address Information -->
                    <div class="mb-3">
                        <label for="address">Address</label>
                        <textarea name="address" id="address" class="form-control" required>{{ old('address') }}</textarea>

                        @error('address')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="district">District/Area</label>
                        <input type="text" name="district" id="district" class="form-control" value="{{ old('district') }}" required>

                        @error('district')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="nationality">Nationality</label>
                        <input type="text" name="nationality" id="nationality" class="form-control" value="{{ old('nationality') }}" required>

                        @error('nationality')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="place_of_birth">Place of Birth</label>
                        <input type="text" name="place_of_birth" id="place_of_birth" class="form-control" value="{{ old('place_of_birth') }}" required>

                        @error('place_of_birth')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="birth_date">Birth Date</label>
                        <input type="date" name="birth_date" id="birth_date" class="form-control" value="{{ old('birth_date') }}" required>

                        @error('birth_date')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="national_id">National ID</label>
                        <input type="text" name="national_id" id="national_id" class="form-control" value="{{ old('national_id') }}" required>

                        @error('national_id')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="year_of_entry">Year of Entry</label>
                        <input type="number" name="year_of_entry" id="year_of_entry" class="form-control" value="{{ old('year_of_entry') }}" required>

                        @error('year_of_entry')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Transfer Information -->
                    <div class="mb-3">
                        <label for="is_transferred">Is the student transferred from another school?</label>
                        <select name="is_transferred" id="is_transferred" class="form-control" required>
                            <option value="0" {{ old('is_transferred') == '0' ? 'selected' : '' }}>No</option>
                            <option value="1" {{ old('is_transferred') == '1' ? 'selected' : '' }}>Yes</option>
                        </select>

                        @error('is_transferred')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3" id="former_school_name_container" style="display: none;">
                        <label for="former_school_name">Former School Name</label>
                        <input type="text" name="former_school_name" id="former_school_name" class="form-control" value="{{ old('former_school_name') }}">

                        @error('former_school_name')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <!-- File Uploads -->
                    <div class="mb-3">
                        <label for="photo">Student Photo (optional)</label>
                        <input type="file" name="photo" id="photo" class="form-control-file">

                        @error('photo')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="birth_certificate">Birth Certificate (optional)</label>
                        <input type="file" name="birth_certificate" id="birth_certificate" class="form-control-file">

                        @error('birth_certificate')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Contacts Section -->
                    <h4>Contacts</h4>
                    <button type="button" class="btn btn-secondary" onclick="addContact()">Add Contact</button>

                    <div id="contacts-section">
                        <!-- Dynamically added contact fields will appear here -->
                    </div>

                    <!-- Sibling Relationships -->
                    <div class="mb-3">
                        <label for="sibling_search" class="form-label">Siblings (Select Multiple)</label>
                        <input type="text" id="sibling_search" class="form-control" placeholder="Type to search siblings">
                        
                        <!-- Container for displaying selected siblings -->
                        <div id="selected_siblings" class="mt-2">
                            <!-- Tags for selected siblings will appear here -->
                        </div>

                        <!-- Hidden input to store selected sibling IDs -->
                        <input type="hidden" name="sibling_ids" id="sibling_ids">
                    </div>

                    <!-- Associations -->
                    <div class="mb-3">
                        <label for="grade_id">Grade</label>
                        <select name="grade_id" id="grade_id" class="form-control" required>
                            @foreach ($grades as $grade)
                                <option value="{{ $grade->id }}" {{ old('grade_id') == $grade->id ? 'selected' : '' }}>
                                    {{ $grade->name }}
                                </option>
                            @endforeach
                        </select>

                        @error('grade_id')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="school_id">School</label>
                        <select name="school_id" id="school_id" class="form-control" required>
                            @foreach ($schools as $school)
                                <option value="{{ $school->id }}" {{ old('school_id') == $school->id ? 'selected' : '' }}>
                                    {{ $school->name }}
                                </option>
                            @endforeach
                        </select>

                        @error('school_id')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="neighborhood_id">Neighborhood</label>
                        <select name="neighborhood_id" id="neighborhood_id" class="form-control" required>
                            @foreach ($neighborhoods as $neighborhood)
                                <option value="{{ $neighborhood->id }}" {{ old('neighborhood_id') == $neighborhood->id ? 'selected' : '' }}>
                                    {{ $neighborhood->name }}
                                </option>
                            @endforeach
                        </select>

                        @error('neighborhood_id')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="note" class="form-label">Add a Note (optional)</label>
                        <textarea name="note" class="form-control" rows="3">{{ old('note') }}</textarea>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-plus me-1"></span> Add New Student
                </button>
            </div>
        </div>
    </form>

    <script>
        // Toggle former school name based on transfer status
        document.getElementById('is_transferred').addEventListener('change', function () {
            const formerSchoolNameContainer = document.getElementById('former_school_name_container');
            if (this.value === '1') {
                formerSchoolNameContainer.style.display = 'block';
                document.getElementById('former_school_name').setAttribute('required', 'required');
            } else {
                formerSchoolNameContainer.style.display = 'none';
                document.getElementById('former_school_name').removeAttribute('required');
            }
        });

        // Add a new contact dynamically
        function addContact() {
            const container = document.getElementById('contacts-section');
            const index = container.children.length;

            container.insertAdjacentHTML('beforeend', `
                <div class="contact-group">
                    <div class="form-group">
                        <label for="contacts[${index}][contact_number]">Contact Number</label>
                        <input type="text" name="contacts[${index}][contact_number]" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="contacts[${index}][type]">Type</label>
                        <select name="contacts[${index}][type]" class="form-control" required>
                            <option value="home">Home</option>
                            <option value="mobile">Mobile</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="contacts[${index}][owned_by]">Owned By</label>
                        <select name="contacts[${index}][owned_by]" class="form-control" required>
                            <option value="father">Father</option>
                            <option value="mother">Mother</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="contacts[${index}][notes]">Notes (optional)</label>
                        <textarea name="contacts[${index}][notes]" class="form-control"></textarea>
                    </div>
                    <button type="button" class="btn btn-danger" onclick="removeContact(this)">Remove</button>
                    <hr>
                </div>
            `);
        }

        // Remove a contact dynamically
        function removeContact(button) {
            button.closest('.contact-group').remove();
        }

        // On page load, check the value of 'is_transferred' to set the correct display state
        document.addEventListener('DOMContentLoaded', function() {
            const isTransferred = document.getElementById('is_transferred').value;
            const formerSchoolNameContainer = document.getElementById('former_school_name_container');
            if (isTransferred === '1') {
                formerSchoolNameContainer.style.display = 'block';
                document.getElementById('former_school_name').setAttribute('required', 'required');
            } else {
                formerSchoolNameContainer.style.display = 'none';
                document.getElementById('former_school_name').removeAttribute('required');
            }
        });

        // Student Siblings Scripts
        $(document).ready(function() {
            // Initialize the Select2 library (optional, you can use jQuery UI Autocomplete or another method)
            $('#sibling_search').select2({
                placeholder: 'Type to search siblings',
                ajax: {
                    url: '{{ route("admin.students.siblings.search") }}',
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            query: params.term // search term
                        };
                    },
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (item) {
                                return {
                                    id: item.id,
                                    text: item.name
                                };
                            })
                        };
                    },
                    cache: true
                }
            });

            // Handling sibling selection
            $('#sibling_search').on('select2:select', function(e) {
                var data = e.params.data;

                // Append selected sibling as a tag
                $('#selected_siblings').append(
                    `<span class="badge bg-primary me-1 sibling-tag" data-id="${data.id}">
                        ${data.text} <i class="ti ti-close" onclick="removeSibling(${data.id})"></i>
                    </span>`
                );

                // Update hidden input with selected sibling IDs
                updateSiblingIds();
            });
        });

        // Function to remove a sibling tag
        function removeSibling(id) {
            $(`.sibling-tag[data-id="${id}"]`).remove();
            updateSiblingIds();
        }

        // Function to update hidden input with selected sibling IDs
        function updateSiblingIds() {
            var selectedIds = [];
            $('.sibling-tag').each(function() {
                selectedIds.push($(this).data('id'));
            });
            $('#sibling_ids').val(selectedIds.join(','));
        }
    </script>

    <style>
        .sibling-tag {
            display: inline-block;
            padding: 5px 10px;
            background-color: #28a745;
            color: white;
            border-radius: 5px;
            margin-right: 5px;
            margin-bottom: 5px;
        }

        .sibling-tag i {
            margin-left: 5px;
            cursor: pointer;
        }
    </style>
@endsection
