@extends('layouts/layoutMaster')

@section('title', 'School: '. $school->name)

@section('content')
    <div class="container mt-4">
        <div class="card">
            <div class="card-header">
                <h4>School: {{ $school->name }}</h4>
            </div>
            <div class="card-body">
                <h5>School Information</h5>
                <p><strong>Name:</strong> {{ $school->name }}</p>
                <p><strong>Address:</strong> {{ $school->address }}</p>
                <p><strong>Phone:</strong> {{ $school->phone }}</p>
                <p><strong>Principal:</strong> {{ $school->principal }}</p>

                <!-- Related Students -->
                <h5>Students</h5>
                @if($school->students->count() > 0)
                    <ul>
                        @foreach($school->students as $student)
                            <li>{{ $student->name }} - {{ $student->class }}</li>
                        @endforeach
                    </ul>
                @else
                    <p>No students found for this school.</p>
                @endif

                <!-- Related Employees -->
                <h5>Employees</h5>
                @if($school->users->count() > 0)
                    <ul>
                        @foreach($school->users as $employee)
                            <li>{{ $employee->name }} - {{ $employee->position }}</li>
                        @endforeach
                    </ul>
                @else
                    <p>No employees found for this school.</p>
                @endif

                <a href="{{ route('admin.schools.index') }}" class="btn btn-primary">Back to Schools</a>
            </div>
        </div>
    </div>
@endsection
