@extends('layouts/layoutMaster')

@section('title', 'Schools')

@section('content')
    <h4>All Schools</h4>

    <div class="card">
        <h5 class="card-header">Schools Table</h5>

        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Logo</th>
                            <th>Name</th>
                            <th>City</th>
                            <th>State</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach($schools as $school)
                            <tr @if($school->trashed()) class="table-warning" @endif>
                                <td>
                                    @if($school->logo)
                                        <img src="{{ asset('storage/' . $school->logo) }}" alt="{{ $school->name }}" style="max-width: 100px;">
                                    @else
                                        No Logo
                                    @endif
                                </td>
                                <td>{{ $school->name }}</td>
                                <td>{{ $school->city }}</td>
                                <td>{{ $school->state }}</td>
                                <td>{{ $school->status }}</td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        @if(!$school->trashed())
                                            <a class="dropdown-item" href="{{ route('admin.schools.edit', $school->id) }}">
                                                <i class="ti ti-pencil me-1"></i>
                                                Edit
                                            </a>

                                            <a class="dropdown-item" href="{{ route('admin.schools.show', $school->id) }}">
                                                <i class="ti ti-eye me-1"></i>
                                                Show
                                            </a>

                                            <form action="{{ route('admin.schools.destroy', $school->id) }}" method="POST"  id="deleteForm{{ $school->id }}" style="display:inline;">
                                                @csrf
                                                @method('DELETE')

                                                <button type="submit" class="dropdown-item btn btn-danger">
                                                    <i class="ti ti-trash me-1"></i>
                                                    Delete
                                                </button>
                                            </form>
                                        @else
                                            <div class="dropdown-menu">
                                                <form action="{{ route('admin.schools.restore', $school->id) }}" method="POST" style="display:inline;">
                                                    @csrf
                                                    @method('PATCH')

                                                    <button type="submit" class="dropdown-item btn btn-success">
                                                        <i class="ti ti-restore me-1"></i>
                                                        Restore
                                                    </button>
                                                </form>

                                                <form action="{{ route('admin.schools.forceDelete', $school->id) }}" method="POST" style="display:inline;" id="deleteForm{{ $school->id }}">
                                                    @csrf
                                                    @method('DELETE')

                                                    <button type="submit" class="dropdown-item btn btn-danger" onclick="confirmDelete('{{ $school->id }}')">
                                                        <i class="ti ti-trash me-1"></i>
                                                        Force Delete
                                                    </button>
                                                </form>
                                            </div>
                                        @endif
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(schoolId) {
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this school! There might be related employees or students to this school',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + schoolId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                    
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                {{ $schools->links() }}
            </div>
        </div>
    </div>
@endsection