@extends('layouts/layoutMaster')

@section('title', 'Edit School')

@section('content')
    <form action="{{ route('admin.schools.update', $school->id) }}" method="POST" enctype="multipart/form-data">
        @csrf

        @method('PUT')

        <h4>Edit School</h4>

        <div class="col-12 col-lg-8">
            <!-- School Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">School Information</h5>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="mb-3">
                        <label for="name">School Name</label>
                        <input type="text" name="name" class="form-control" value="{{ $school->name }}" required>
                        
                        @error('name')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="logo">School Logo</label>
                        <input type="file" name="logo" class="form-control" accept="image/*">
                        
                        @if($school->logo)
                            <p>Current Logo:</p>
                            <img src="{{ asset('storage/' . $school->logo) }}" alt="{{ $school->name }}" style="max-width: 200px;">
                        @endif
                    </div>

                    <div class="mb-3">
                        <label for="registration_code">Registration Code</label>
                        <input type="text" name="registration_code" class="form-control" value="{{ $school->registration_code }}" required>
                        
                        @error('registration_code')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="email">Contact Email</label>
                        <input type="email" name="email" class="form-control" value="{{ $school->email }}" required>
                        
                        @error('email')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="phone">Phone Number</label>
                        <input type="text" name="phone" class="form-control" value="{{ $school->phone }}">
                        
                        @error('phone')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="website">Website URL</label>
                        <input type="url" name="website" class="form-control" value="{{ $school->website }}">
                        
                        @error('website')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="principal_name">Principal Name</label>
                        <input type="text" name="principal_name" class="form-control" value="{{ $school->principal_name }}">
                        
                        @error('principal_name')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="founded_year">Year Founded</label>
                        <input type="number" name="founded_year" class="form-control" value="{{ $school->founded_year }}" min="1800" max="{{ date('Y') }}">
                        
                        @error('founded_year')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="student_capacity">Student Capacity</label>
                        <input type="number" name="student_capacity" class="form-control" value="{{ $school->student_capacity }}">
                        
                        @error('student_capacity')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="type">School Type</label>
                        <select name="type" class="form-control">
                            <option value="public" {{ $school->type == 'public' ? 'selected' : '' }}>Public</option>
                            <option value="private" {{ $school->type == 'private' ? 'selected' : '' }}>Private</option>
                            <option value="charter" {{ $school->type == 'charter' ? 'selected' : '' }}>Charter</option>
                        </select>
                        
                        @error('type')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="status">Status</label>
                        <select name="status" class="form-control">
                            <option value="active" {{ $school->status == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ $school->status == 'inactive' ? 'selected' : '' }}>Inactive</option>
                            <option value="pending" {{ $school->status == 'pending' ? 'selected' : '' }}>Pending</option>
                        </select>
                        
                        @error('status')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <h4>Address Information</h4>

                    <div class="mb-3">
                        <label for="address">Address</label>
                        <input type="text" name="address" class="form-control" value="{{ $school->address }}">
                        
                        @error('address')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="city">City</label>
                        <input type="text" name="city" class="form-control" value="{{ $school->city }}" required>
                        
                        @error('city')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="state">State/Region</label>
                        <input type="text" name="state" class="form-control" value="{{ $school->state }}" required>
                        
                        @error('state')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="country">Country</label>
                        <input type="text" name="country" class="form-control" value="{{ $school->country }}" required>
                        
                        @error('country')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="zipcode">Zip/Postal Code</label>
                        <input type="text" name="zipcode" class="form-control" value="{{ $school->zipcode }}">
                        
                        @error('zipcode')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-check me-1"></span> Update Role
                </button>
            </div>
        </div>
    </form>
@endsection