@extends('layouts/layoutMaster')

@section('title', 'Create New School')

@section('content')
    <form action="{{ route('admin.schools.store') }}" method="POST" enctype="multipart/form-data">
        @csrf 
          
        <h4>Create New Schools</h4>

        <div class="col-12 col-lg-8">
            <!-- School  Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">Schools Information</h5>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="mb-3">
                        <label class="form-label" for="school-name">School Name</label>

                        <input type="text" class="form-control" id="school-name" placeholder="School Name" name="name" aria-label="School Name"  value="{{ old('name') }}" required />
                        
                        @error('name')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="logo">School Logo</label>
                        <input type="file" name="logo" class="form-control" accept="image/*">
                    </div>

                    <div class="mb-3">
                        <label for="registration_code">Registration Code</label>
                        
                        <input type="text" name="registration_code" class="form-control" value="{{ old('registration_code') }}" required>
                        
                        @error('registration_code')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="email">Contact Email</label>
                        
                        <input type="email" name="email" class="form-control" value="{{ old('email') }}" required>
                        
                        @error('email')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="phone">Phone Number</label>
                        
                        <input type="text" name="phone" class="form-control" value="{{ old('phone') }}">
                        
                        @error('phone')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="website">Website URL</label>
                        
                        <input type="url" name="website" class="form-control" value="{{ old('website') }}">
                        
                        @error('website')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="principal_name">Principal Name</label>
                        
                        <input type="text" name="principal_name" class="form-control" value="{{ old('principal_name') }}">
                        
                        @error('principal_name')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="founded_year">Year Founded</label>
                        
                        <input type="number" name="founded_year" class="form-control" value="{{ old('founded_year') }}" min="1800" max="{{ date('Y') }}">
                        
                        @error('founded_year')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="student_capacity">Student Capacity</label>
                        
                        <input type="number" name="student_capacity" class="form-control" value="{{ old('student_capacity') }}">
                        
                        @error('student_capacity')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="type">School Type</label>
                        
                        <select name="type" class="form-control">
                            <option value="public" {{ old('type') == 'public' ? 'selected' : '' }}>Public</option>
                            <option value="private" {{ old('type') == 'private' ? 'selected' : '' }}>Private</option>
                            <option value="charter" {{ old('type') == 'charter' ? 'selected' : '' }}>Charter</option>
                        </select>
                        
                        @error('type')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="status">Status</label>
                        
                        <select name="status" class="form-control">
                            <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ old('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                            <option value="pending" {{ old('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                        </select>
                        
                        @error('status')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <h4>Address Information</h4>

                    <div class="mb-3">
                        <label for="address">Address</label>
                        
                        <input type="text" name="address" class="form-control" value="{{ old('address') }}">
                        
                        @error('address')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="city">City</label>
                        
                        <input type="text" name="city" class="form-control" value="{{ old('city') }}" required>
                        
                        @error('city')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="state">State/Region</label>
                        
                        <input type="text" name="state" class="form-control" value="{{ old('state') }}" required>
                        
                        @error('state')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="country">Country</label>
                        
                        <input type="text" name="country" class="form-control" value="{{ old('country') }}" required>
                        
                        @error('country')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="zipcode">Zip/Postal Code</label>
                        
                        <input type="text" name="zipcode" class="form-control" value="{{ old('zipcode') }}">
                        
                        @error('zipcode')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-plus me-1"></span> Add New School
                </button>
            </div>
        </div>
    </form>
@endsection
