@extends('layouts/layoutMaster')

@section('title', 'Role: '. $role->name)

@section('content')
    <div class="col-12 col-lg-12">
        <!-- Role Information -->

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-tile mb-0">Role: {{ $role->name }}</h5>
            </div>

            <div class="card-body">
                <div class="mb-3">
                    <label>Assigned Permissions:</label>

                    @if ($role->permissions->isEmpty())
                        <p>No permissions assigned to this role.</p>
                    @else
                        <ul>
                            @foreach ($role->permissions as $permission)
                                <li>{{ $permission->name }}</li>
                            @endforeach
                        </ul>
                    @endif

                    <a href="{{ route('admin.roles.index') }}" class="btn btn-primary">Back to Roles</a>
                </div>
            </div>
        </div>
    </div>
@endsection
