@extends('layouts/layoutMaster')

@section('title', 'Roles')

@section('content')
    <h4>All Roles</h4>

    <div class="card">
        <h5 class="card-header">Roles Table</h5>

        <div class="card-body">
            @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Name</th>
                            <th>Permissions Count</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($roles as $role)
                            <tr>
                                <td>{{ $role->name }}</td>
                                <td>{{ $role->permissions_count }}</td> <!-- Display permissions count -->
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="{{ route('admin.roles.edit', $role->id) }}">
                                                <i class="ti ti-pencil me-1"></i>
                                                Edit
                                            </a>

                                            <a class="dropdown-item" href="{{ route('admin.roles.show', $role->id) }}">
                                                <i class="ti ti-eye me-1"></i>
                                                Show
                                            </a>
                                            
                                            @if($role->id != 1) <!-- Assuming Super Admin has ID 1 -->
                                                <form action="{{ route('admin.roles.destroy', $role->id) }}" method="POST" class="d-inline" id="deleteForm{{ $role->id }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="button" class="dropdown-item delete-role-btn" data-role-id="{{ $role->id }}" onclick="confirmDelete('{{ $role->id }}')">
                                                        <i class="ti ti-trash me-1"></i>
                                                        Delete
                                                    </button>
                                                </form>
                                            @else
                                                <button type="button" class="dropdown-item" disabled><i class="ti ti-trash me-1"></i> Delete Disabled</button>
                                            @endif
                                        </div>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(authorId) {
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this role! There might be permissions related to this role and this role might be assigned to one of the employees',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + authorId).submit();
                                                }
                                            });
                                        }

                                        document.addEventListener('DOMContentLoaded', function () {
                                            document.querySelectorAll('.delete-role-btn').forEach(function (button) {
                                                button.addEventListener('click', function (e) {
                                                    const roleId = button.getAttribute('data-role-id');

                                                    // Assuming '1' is the ID for Super Admin role
                                                    if (roleId == 1) {
                                                        e.preventDefault();
                                                        alert('You cannot delete the Super Admin role.');
                                                    }
                                                });
                                            });
                                        });
                                    </script>
                                    
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection