@extends('layouts/layoutMaster')

@section('title', 'Edit Role')

@section('content')
    <form action="{{ route('admin.roles.update', $role->id) }}" method="POST">
        @csrf

        @method('PUT')

        <h4>Edit Role</h4>

        <div class="col-12 col-lg-8">
            <!-- Role Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">Role Information</h5>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="mb-3">
                        <label class="form-label" for="book-name">Role Name</label>
                        
                        <input type="text" class="form-control" id="role-name" placeholder="Role Name" name="name" aria-label="Role Name" value="{{ $role->name }}" required />
                        
                        @error('name')
                            <div style="color: red; font-weight: bold"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="permissions">Assign Permissions</label>

                        <div>
                            @foreach($permissions as $permission)
                                <div class="form-check">
                                    <input 
                                        type="checkbox" 
                                        name="permissions[]" 
                                        value="{{ $permission->id }}" 
                                        class="form-check-input"
                                        id="permission{{ $permission->id }}"
                                        {{ isset($role) && $role->permissions->contains($permission->id) ? 'checked' : '' }}
                                        {{ isset($role) && $role->name == 'Super Admin' ? 'disabled' : '' }}>
                                    <label class="form-check-label" for="permission{{ $permission->id }}">
                                        {{ $permission->name }}
                                    </label>
                                </div>
                            @endforeach
                        </div>                      
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-check me-1"></span> Update Role
                </button>
            </div>
        </div>
    </form>
@endsection