@extends('layouts/layoutMaster')

@section('title', 'Pages')

@section('content')
    <h4>All Pages</h4>

    <div class="card">
        <h5 class="card-header">Pages Table</h5>

        <div class="card-body">
            <!-- Display success or error messages -->
            @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Title</th>
                            <th>Status</th>
                            <th>Created At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($pages as $page)
                            <tr>
                                <td>{{ $page->title }}</td>
                                <td>{{ ucfirst($page->status) }}</td>
                                <td>{{ $page->created_at->format('Y-m-d H:i:s') }}</td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <a class="dropdown-item" href="{{ route('pages.edit', $page->slug) }}">
                                            <i class="ti ti-pencil me-1"></i>
                                            Show
                                        </a>

                                        <a class="dropdown-item" href="{{ route('pages.edit', $page->id) }}">
                                            <i class="ti ti-pencil me-1"></i>
                                            Edit
                                        </a>

                                        @if(!$page->trashed())
                                            <form action="{{ route('admin.pages.destroy', $page) }}" method="POST" id="deleteForm{{ $page->id }}" style="display:inline-block;">
                                                @csrf

                                                @method('DELETE')

                                                <button type="submit" class="btn btn-danger" onclick="confirmDelete(event, '{{ $page->id }}')">Delete</button>
                                            </form>
                                        @else
                                            <form action="{{ route('admin.pages.restore', $page->id) }}" method="POST" style="display:inline-block;">
                                                @csrf

                                                <button type="submit" class="btn btn-info">Restore</button>
                                            </form>

                                            <form action="{{ route('admin.pages.forceDelete', $page->id) }}" method="POST" id="deleteForm{{ $page->id }}" style="display:inline-block;">
                                                @csrf

                                                @method('DELETE')

                                                <button type="submit" class="btn btn-danger" onclick="confirmDelete(event, '{{ $page->id }}')">Force Delete</button>
                                            </form>
                                        @endif
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(event, pageId) {
                                            // Prevent the default form submission
                                            event.preventDefault();

                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this page',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + pageId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection