@extends('layouts/layoutMaster')

@section('title', isset($page) ? 'Edit Page' : 'Create New Page')

@section('content')
    <form action="{{ isset($page) ? route('admin.pages.update', $page->id) : route('admin.pages.store') }}" method="POST">
        @csrf 
          
        <h4>{{ isset($page) ? 'Edit Page' : 'Create New Page' }}</h4>

        <div class="col-12 col-lg-8">
            <!-- School  Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">Page Information</h5>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    @if (isset($page))
                        @method('PUT')
                    @endif

                    <div class="form-group">
                        <label>Title</label>
                        <input type="text" name="title" value="{{ old('title', $page->title ?? '') }}" class="form-control">
                    </div>

                    <!-- Slug Field -->
                    <div class="form-group" id="slug-wrapper">
                        @if(isset($page))
                            <!-- Edit Page View -->
                            <div id="slug-view" style="display: inline-block;">
                                <a href="{{ url('/') }}/{{ $page->slug }}" target="_blank" id="slug-link">{{ url('/') }}/{{ $page->slug }}</a>
                                <button type="button" id="edit-slug-btn" class="btn btn-link">Edit</button>
                            </div>
                            <div id="slug-edit" style="display: none;">
                                <span>{{ url('/') }}/</span>
                                <input type="text" name="slug" id="slug" value="{{ old('slug', $page->slug ?? '') }}" class="form-control slug-input" style="display: inline-block; width: auto;">
                                <button type="button" id="cancel-slug-btn" class="btn btn-link">Cancel</button>
                                <span id="slug-status"></span>
                            </div>
                        @else
                            <!-- Create Page View (hidden slug input, generated automatically) -->
                            <input type="hidden" name="slug" id="slug" value="{{ old('slug', $page->slug ?? '') }}">
                        @endif
                    </div>

                    <div class="form-group">
                        <label>Content</label>
                        <textarea name="content" class="form-control">{{ old('content', $page->content ?? '') }}</textarea>
                    </div>

                    <div class="form-group">
                        <label>Parent Page</label>
                        <select name="parent_id" class="form-control">
                            <option value="">-- None --</option>
                            @foreach($parentPages as $parentPage)
                                <option value="{{ $parentPage->id }}" {{ old('parent_id', $page->parent_id ?? '') == $parentPage->id ? 'selected' : '' }}>{{ $parentPage->title }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Status</label>
                        <select name="status" class="form-control">
                            <option value="draft" {{ old('status', $page->status ?? '') == 'draft' ? 'selected' : '' }}>Draft</option>
                            <option value="published" {{ old('status', $page->status ?? '') == 'published' ? 'selected' : '' }}>Published</option>
                            <option value="scheduled" {{ old('status', $page->status ?? '') == 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Publish Date</label>
                        <input type="datetime-local" name="publish_at" value="{{ old('publish_at', isset($page->publish_at) ? $page->publish_at->format('Y-m-d\TH:i') : '') }}" class="form-control">
                    </div>

                    <!-- Featured Image -->
                    <div class="form-group">
                        <label for="featured_image">Featured Image</label>

                        <div id="featured-image-preview">
                            @if(isset($page) && $page->featured_image)
                                <img src="{{ $page->featuredImage->url }}" style="max-width: 200px;">
                            @endif
                        </div>

                        <button type="button" id="select-media-btn" class="btn btn-secondary">Select from Media Library</button>

                        <input type="hidden" name="featured_image" id="featured_image" value="{{ old('featured_image', $page->featured_image ?? '') }}">
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-plus me-1"></span> Save Page Information
                </button>
            </div>
        </div>
    </form>

    <!-- Media Library Modal -->
    <div id="media-library-modal" class="modal" style="display:none;">
        <div class="modal-content">
            <span id="close-media-library" class="close">&times;</span>
            <div class="modal-header">
                <h3>Select or Upload Media</h3>
            </div>
            <div class="modal-body">
                <!-- Tabs for Upload / Media Library -->
                <ul class="nav nav-tabs" id="media-tabs">
                    <li class="nav-item">
                        <a class="nav-link active" id="upload-tab" href="#upload-section">Upload Files</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="library-tab" href="#library-section">Media Library</a>
                    </li>
                </ul>

                <!-- Upload Section -->
                <div id="upload-section" class="tab-pane active">
                    <input type="file" id="media-upload-input" multiple>
                    <div id="upload-preview"></div>
                </div>

                <!-- Media Library Section -->
                <div id="library-section" class="tab-pane">
                    <div id="media-items"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- jQuery for slug generation and toggling between link and input field -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            //=============================================================================
            // Page slug scripts
            //=============================================================================

            // Function to convert title to slug
            function generateSlug(value) {
                return value
                    .toString()
                    .toLowerCase()
                    .replace(/\s+/g, '-') // Replace spaces with hyphens
                    .replace(/[^\w\-]+/g, '') // Remove all non-word characters
                    .replace(/\-\-+/g, '-')   // Replace multiple hyphens with single hyphen
                    .replace(/^-+/, '')       // Trim hyphens from the start
                    .replace(/-+$/, '');      // Trim hyphens from the end
            }

            // For Create Page: Auto-generate slug when typing title
            @if(!isset($page))
                $('#title').on('input', function() {
                    let title = $(this).val();
                    let slug = generateSlug(title);
                    $('#slug').val(slug);
                });
            @endif

            // For Edit Page: Toggle slug input field
            @if(isset($page))
                $('#edit-slug-btn').on('click', function() {
                    $('#slug-view').hide();
                    $('#slug-edit').show();
                });

                $('#cancel-slug-btn').on('click', function() {
                    $('#slug-edit').hide();
                    $('#slug-view').show();
                });

                // If slug is manually edited, check for uniqueness via AJAX
                $('#slug').on('input', function() {
                    let slug = $(this).val();
                    checkSlugUnique(slug);
                });
            @endif

            // AJAX to check if the slug is unique
            function checkSlugUnique(slug) {
                let pageId = "{{ isset($page) ? $page->id : '' }}"; // Get the current page ID (if editing)

                $.ajax({
                    url: '{{ route("admin.pages.checkSlug") }}',
                    type: 'GET',
                    data: { slug: slug, id: pageId },
                    success: function(response) {
                        if (response.exists) {
                            // Slug exists, suggest an alternate slug
                            let suggestedSlug = response.suggested_slug;
                            $('#slug-status').text('Slug exists. Suggested: ' + suggestedSlug).css('color', 'red');
                            $('#slug').val(suggestedSlug);
                        } else {
                            // Slug is available
                            $('#slug-status').text('Slug is available').css('color', 'green');
                        }
                    },
                    error: function(xhr) {
                        console.log("Error checking slug:", xhr);
                    }
                });
            }
        });
    </script>
@endsection
