@extends('layouts/layoutMaster')

@section('title', 'Neighborhoods')

@section('content')
    <h4>All Neighborhoods</h4>

    <div class="card">
        <h5 class="card-header">Neighborhoods Table</h5>

        <a href="{{ route('neighborhoods.create') }}">Add Neighborhood</a>
        
        <div class="card-body">
            <!-- Display success or error messages -->
            @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Name</th>
                            <th>Number of students</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($neighborhoods as $neighborhood)
                            <tr>
                                <td>
                                    {{ $neighborhood->name }} (District: {{ $neighborhood->district->name }})
                                </td>
                                <td>
                                    {{ $neighborhood->students->count() }} students
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <a class="dropdown-item" href="{{ route('neighborhoods.edit', $neighborhood->id) }}">
                                            <i class="ti ti-pencil me-1"></i>
                                            Edit
                                        </a>

                                        <a class="dropdown-item" href="{{ route('neighborhoods.show', $neighborhood->id) }}">
                                            <i class="ti ti-eye me-1"></i>
                                            Show Students
                                        </a>

                                        <form action="{{ route('neighborhoods.destroy', $neighborhood->id) }}" method="POST" id="deleteForm{{ $neighborhood->id }}" style="display:inline;">
                                            @csrf
                                            @method('DELETE')

                                            <button type="submit" class="dropdown-item btn btn-danger" onclick="confirmDelete('{{ $neighborhood->id }}')">
                                                <i class="ti ti-trash me-1"></i>
                                                Delete
                                            </button>
                                        </form>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(neighborhoodId) {
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this neighborhood there might be related students to this neighborhood',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + neighborhoodId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection