@extends('layouts/layoutMaster')

@section('title', 'Edit Grade')

@section('content')
    <form action="{{ route('grades.update', $grade->id) }}" method="POST">
        @csrf

        @method('PUT')

        <h4>Edit Grade</h4>

        <div class="col-12 col-lg-8">
            <!-- Grade Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">Grade Information</h5>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="mb-3">
                        <label for="name">Grade Name</label>
                        <input type="text" name="name" class="form-control" value="{{ $grade->name }}" required>
                        
                        @error('name')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-check me-1"></span> Update Grade
                </button>
            </div>
        </div>
    </form>
@endsection