@extends('layouts/layoutMaster')

@section('title', 'Media Library')

@section('content')
    <h4>Media Library</h4>

    <div class="card">
        <div class="card-body">
            <div id="media-library">
                @if(count($mediaItems) > 0)
                    @foreach($mediaItems as $media)
                        <div class="media-item" data-id="{{ $media->id }}">
                            <img src="{{ asset('storage/' . $media->file_path) }}" alt="{{ $media->file_name }}" style="max-width: 100px;">

                            <p>{{ $media->file_name }}</p>

                            <button class="btn btn-primary edit-media-btn" data-id="{{ $media->id }}">Edit</button>

                            <form action="{{ route('admin.media.delete', $media) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-danger">Delete</button>
                            </form>
                        </div>
                    @endforeach
                @else
                    <div class="alert alert-info d-flex align-items-center" role="alert">
                        <span class="alert-icon rounded">
                            <i class="ti ti-info-circle"></i>
                        </span>

                        Media library is empty
                    </div>
                @endif
            </div>

            {{ $mediaItems->links() }}

            <!-- Modal for editing media -->
            <div id="edit-media-modal" style="display:none;">
                <form id="edit-media-form">
                    <input type="hidden" name="media_id" id="media_id">

                    <input type="text" name="file_name" id="file_name">

                    <button type="submit">Save</button>
                </form>

                <button id="close-edit-media">Close</button>
            </div>

            <!-- jQuery for media library actions -->
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
            <script>
                $(document).ready(function() {
                    // Open edit modal
                    $('.edit-media-btn').on('click', function() {
                        let mediaId = $(this).data('id');
                        let fileName = $(this).siblings('p').text();
                        $('#media_id').val(mediaId);
                        $('#file_name').val(fileName);
                        $('#edit-media-modal').show();
                    });

                    // Close edit modal
                    $('#close-edit-media').on('click', function() {
                        $('#edit-media-modal').hide();
                    });

                    // Save edited media
                    $('#edit-media-form').on('submit', function(event) {
                        event.preventDefault();
                        let mediaId = $('#media_id').val();
                        let fileName = $('#file_name').val();

                        $.ajax({
                            url: `/admin/media/edit/${mediaId}`,
                            type: 'POST',
                            data: {
                                _token: '{{ csrf_token() }}',
                                file_name: fileName
                            },
                            success: function() {
                                location.reload();  // Reload the page on success
                            }
                        });
                    });
                });
            </script>
        </div>
    </div>
@endsection