@extends('layouts/layoutMaster')

@section('title', 'Sent Invitations')

@section('content')

    <div class="card">
        <h5 class="card-header">Sent Invitations</h5>

        <div class="card-body">
            <table class="table table-bordered table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Token</th>
                        <th>Status</th>
                        <th>Accepted By</th>
                        <th>Sent Date</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach($invitations as $invitation)
                        <tr>
                            <td>{{ $invitation->name ?? 'N/A' }}</td> <!-- Display name if available -->
                            <td>{{ $invitation->email }}</td>
                            <td><small>{{ $invitation->token }}</small></td>
                            <td>{{ ucfirst($invitation->status) }}</td>
                            <td>
                                @if ($invitation->status == 'accepted' && $invitation->user)
                                    <a href="{{ route('users.show', $invitation->user->id) }}">{{ $invitation->user->name }}</a>
                                @else
                                    ---
                                @endif
                            </td>
                            <td>{{ $invitation->created_at->format('Y-m-d') }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection