@extends('layouts/layoutMaster')

@section('title', 'Grade: '. $grade->name)

@section('content')
    <div class="col-12 col-lg-12">
        <!-- Role Information -->

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-tile mb-0">Grade: {{ $grade->name }}</h5>
            </div>

            <div class="card-body">
                <div class="mb-3">
                    <label>Assigned Students:</label>

                    <!-- Check if there are students -->
                    @if ($students->count() > 0)
                        <ul>
                            @foreach ($students as $student)
                                <li>{{ $student->name }} (School: {{ $student->school->name }})</li>
                            @endforeach
                        </ul>

                        <!-- Display pagination controls -->
                        <div>
                            {{ $students->links() }}
                        </div>
                    @else
                        <p>No students assigned to this grade yet.</p>
                    @endif

                    <a href="{{ route('grades.index') }}" class="btn btn-primary">Back to Grades</a>
                </div>
            </div>
        </div>
    </div>
@endsection
