@extends('layouts/layoutMaster')

@section('title', 'Create New Grade')

@section('content')
    <form action="{{ route('grades.store') }}" method="POST">
        @csrf 
          
        <h4>Create New Grade</h4>

        <div class="col-12 col-lg-8">
            <!-- School  Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">Grade Information</h5>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="mb-3">
                        <label class="form-label" for="grade-name">Grade Name</label>

                        <input type="text" class="form-control" id="grade-name" placeholder="Grade Name" name="name" aria-label="Grade Name"  value="{{ old('name') }}" required />
                        
                        @error('name')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-plus me-1"></span> Add New Grade
                </button>
            </div>
        </div>
    </form>
@endsection
