@extends('layouts/layoutMaster')

@section('title', 'District: '. $district->name)

@section('content')
    <div class="col-12 col-lg-12">
        <!-- District Information -->

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-tile mb-0">District: {{ $district->name }}</h5>
            </div>

            <div class="card-body">
                <div class="mb-3">
                    <p>Total Students: 
                        {{ $district->neighborhoods->sum(function ($neighborhood) {
                            return $neighborhood->students->count();
                        }) }}
                    </p>
                    
                    <!-- Check if there are neighborhoods -->
                    @if ($district->neighborhoods->count() > 0)
                        <!-- You can also list neighborhoods and their student counts if needed -->
                        <ul>
                            @foreach ($district->neighborhoods as $neighborhood)
                                <li>
                                    {{ $neighborhood->name }} - Students: {{ $neighborhood->students->count() }}
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <p>No neighborhoods assigned to this district yet.</p>
                    @endif

                    <a href="{{ route('districts.index') }}" class="btn btn-primary">Back to districts</a>
                </div>
            </div>
        </div>
    </div>
@endsection
