@extends('layouts/layoutMaster')

@section('title', 'Districts')

@section('content')
    <h4>All Districts</h4>

    <div class="card">
        <h5 class="card-header">Districts Table</h5>

        <a href="{{ route('districts.create') }}">Add District</a>
        
        <div class="card-body">
            <!-- Display success or error messages -->
            @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Name</th>
                            <th>Total Students</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($districts as $district)
                            <tr>
                                <td>
                                    {{ $district->name }} (Neighborhoods: {{ $district->neighborhoods->count() }})
                                </td>
                                <td>
                                    {{ 
                                        $district->neighborhoods->sum(function ($neighborhood) {
                                            return $neighborhood->students->count();
                                        }) 
                                    }} Students
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <a class="dropdown-item" href="{{ route('districts.edit', $district->id) }}">
                                            <i class="ti ti-pencil me-1"></i>
                                            Edit
                                        </a>

                                        <a class="dropdown-item" href="{{ route('districts.show', $district->id) }}">
                                            <i class="ti ti-eye me-1"></i>
                                            Show District
                                        </a>

                                        <form action="{{ route('districts.destroy', $district->id) }}" method="POST" id="deleteForm{{ $district->id }}" style="display:inline;">
                                            @csrf
                                            @method('DELETE')

                                            <button type="submit" class="dropdown-item btn btn-danger" onclick="confirmDelete('{{ $district->id }}')">
                                                <i class="ti ti-trash me-1"></i>
                                                Delete
                                            </button>
                                        </form>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(districtId) {
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this district there might be related neighborhoods to this district',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + districtId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection