@extends('layouts/layoutMaster')

@section('title', 'Create New District')

@section('content')
    <form action="{{ route('districts.store') }}" method="POST">
        @csrf 
          
        <h4>Create New District</h4>

        <div class="col-12 col-lg-8">
            <!-- School  Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">District Information</h5>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="mb-3">
                        <label class="form-label" for="district-name">District Name</label>

                        <input type="text" class="form-control" id="district-name" placeholder="District Name" name="name" aria-label="District Name"  value="{{ old('name') }}" required />
                        
                        @error('name')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-plus me-1"></span> Add New District
                </button>
            </div>
        </div>
    </form>
@endsection
