@php
    $customizerHidden = 'customizer-hide';
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Login Basic - Pages')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/@form-validation/form-validation.scss'])
@endsection

@section('page-style')
    @vite(['resources/assets/vendor/scss/pages/page-auth.scss'])
@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js'])
@endsection

@section('page-script')
    @vite(['resources/assets/js/pages-auth.js'])
@endsection

@section('content')
    <div class="container-xxl">
        <div class="authentication-wrapper authentication-basic container-p-y">
            <div class="authentication-inner py-4">
                <!-- Login -->
                <div class="card">
                    <div class="card-body">
                        <!-- Logo -->
                        <div class="app-brand justify-content-center mb-4 mt-2">
                            <a href="{{ url('/') }}" class="app-brand-link gap-2">
                                <span class="app-brand-logo demo">@include('_partials.macros', ['height' => 20, 'withbg' => 'fill: #fff;'])</span>
                                
                                <span class="app-brand-text demo text-body fw-bold ms-1">{{ config('variables.templateName') }}</span>
                            </a>
                        </div>
                        <!-- /Logo -->

                        <h4 class="mb-1 pt-2">Welcome to {{ config('variables.templateName') }}! 👋</h4>

                        <p class="mb-4">Please sign-in to your account and start the adventure</p>

                        <form method="POST" action="{{ route('password.update') }}">
                            @csrf

                            <!-- Password Reset Token -->
                            <input type="hidden" name="token" value="{{ $request->route('token') }}">

                            <!-- Email Address -->
                            <div>
                                <label for="password_confirmation">{{ __('Email') }}</label>

                                <input type="email" placeholder="Email Address" value="{{ old('email', $request->email) }}" name="email" type="password" autocomplete="off" class="form-control bg-transparent"/>

                                @error('email')
                                    <div style="color: red; font-weight: bold"> {{ $errors->get('email') }}</div>
                                @enderror
                            </div>

                            <!-- Password -->
                            <div class="mt-4">
                                <label for="password_confirmation">{{ __('Password') }}</label>

                                <input type="text" placeholder="Password" name="password" type="password" autocomplete="off" class="form-control bg-transparent"/>

                                @error('password')
                                    <div style="color: red; font-weight: bold"> {{ $errors->get('password') }}</div>
                                @enderror
                            </div>

                            <!-- Confirm Password -->
                            <div class="mt-4">
                                <label for="password_confirmation">{{ __('Confirm Password') }}</label>

                                <input type="password" placeholder="{{ __('Confirm Password') }}" name="password_confirmation" autocomplete="off" class="form-control bg-transparent"/>

                                @error('password_confirmation')
                                    <div style="color: red; font-weight: bold"> {{ $errors->get('password_confirmation') }}</div>
                                @enderror
                            </div>

                            <div class="flex items-center justify-end mt-4">
                                <button type="submit" id="kt_sign_up_submit" class="btn btn-primary">{{ __('Reset Password') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- /Login -->
            </div>
        </div>
    </div>
@endsection