@extends('layouts/layoutMaster')

@section('title', 'Announcements')

@section('content')
    <h4>All Announcements</h4>

    <div class="card">
        <h5 class="card-header">Announcements Table</h5>

        <div class="card-body">
            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Title</th>
                            <th>Type</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach($announcements as $announcement)
                            <tr>
                                <td>{{ $announcement->name }}</td>
                                <td>{{ $announcement->type  }}</td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <a class="dropdown-item" href="{{ route('admin.announcements.edit', $announcement->id) }}">
                                            <i class="ti ti-pencil me-1"></i>
                                            Edit
                                        </a>
                                        
                                        <form action="{{ route('admin.announcements.destroy', $announcement->id) }}" method="POST" style="display:inline;" id="deleteForm{{ $announcement->id }}">
                                            @csrf
                                            @method('DELETE')

                                            <button type="submit" class="dropdown-item btn btn-danger" onclick="confirmDelete('{{ $announcement->id }}')">
                                                <i class="ti ti-trash me-1"></i>
                                                Delete
                                            </button>
                                        </form>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(announcementId) {
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this announcement! There might be related employees to this announcement',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + schoolId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                    
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection